/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.options.Options;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import com.maddyhome.idea.copyright.util.NewFileTracker;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CopyrightManager", storages={@Storage(value="copyright", stateSplitter=CopyrightStateSplitter.class)})
public class CopyrightManager
extends AbstractProjectComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CopyrightManager.class.getName()));
    @Nullable
    private CopyrightProfile myDefaultCopyright = null;
    private final LinkedHashMap<String, String> myModuleToCopyrights = new LinkedHashMap();
    private final Map<String, CopyrightProfile> myCopyrights = new TreeMap<String, CopyrightProfile>();
    private final Options myOptions = new Options();
    @NonNls
    private static final String COPYRIGHT = "copyright";
    @NonNls
    private static final String MODULE2COPYRIGHT = "module2copyright";
    @NonNls
    private static final String ELEMENT = "element";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String DEFAULT = "default";

    public CopyrightManager(@NotNull Project project, final @NotNull EditorFactory editorFactory, final @NotNull Application application, final @NotNull FileDocumentManager fileDocumentManager, final @NotNull FileTypeUtil fileTypeUtil, final @NotNull ProjectRootManager projectRootManager, final @NotNull PsiManager psiManager, @NotNull StartupManager startupManager) {
        super(project);
        if (!this.myProject.isDefault()) {
            final NewFileTracker newFileTracker = NewFileTracker.getInstance();
            Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                public void dispose() {
                    newFileTracker.clear();
                }
            });
            startupManager.runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    DocumentAdapter listener = new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            Document document = e.getDocument();
                            final VirtualFile virtualFile = fileDocumentManager.getFile(document);
                            if (virtualFile == null) {
                                return;
                            }
                            final Module module = projectRootManager.getFileIndex().getModuleForFile(virtualFile);
                            if (module == null) {
                                return;
                            }
                            if (!newFileTracker.poll(virtualFile)) {
                                return;
                            }
                            if (!fileTypeUtil.isSupportedFile(virtualFile)) {
                                return;
                            }
                            if (psiManager.findFile(virtualFile) == null) {
                                return;
                            }
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CopyrightProfile opts;
                                    if (!virtualFile.isValid()) {
                                        return;
                                    }
                                    PsiFile file = psiManager.findFile(virtualFile);
                                    if (file != null && file.isWritable() && (opts = CopyrightManager.this.getCopyrightOptions(file)) != null) {
                                        new UpdateCopyrightProcessor(CopyrightManager.this.myProject, module, file).run();
                                    }
                                }
                            }, ModalityState.NON_MODAL, CopyrightManager.this.myProject.getDisposed());
                        }
                    };
                    editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)listener, (Disposable)CopyrightManager.this.myProject);
                }
            });
        }
    }

    public static CopyrightManager getInstance(Project project) {
        return (CopyrightManager)((Object)project.getComponent(CopyrightManager.class));
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "CopyrightManager";
    }

    public Element getState() {
        Element state = new Element("settings");
        try {
            if (!this.myCopyrights.isEmpty()) {
                for (CopyrightProfile copyright : this.myCopyrights.values()) {
                    Element copyrightElement = new Element(COPYRIGHT);
                    copyright.writeExternal(copyrightElement);
                    if (JDOMUtil.isEmpty((Element)copyrightElement)) continue;
                    state.addContent(copyrightElement);
                }
            }
            if (!this.myModuleToCopyrights.isEmpty()) {
                Element map = new Element(MODULE2COPYRIGHT);
                for (String moduleName : this.myModuleToCopyrights.keySet()) {
                    Element setting = new Element(ELEMENT);
                    setting.setAttribute(MODULE, moduleName);
                    setting.setAttribute(COPYRIGHT, this.myModuleToCopyrights.get(moduleName));
                    map.addContent(setting);
                }
                state.addContent(map);
            }
            this.myOptions.writeExternal(state);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (this.myDefaultCopyright != null) {
            state.setAttribute(DEFAULT, this.myDefaultCopyright.getName());
        } else if (!this.myProject.isDefault()) {
            state.setAttribute(DEFAULT, "");
        }
        return state;
    }

    public void loadState(Element state) {
        this.clearCopyrights();
        Element moduleToCopyright = state.getChild(MODULE2COPYRIGHT);
        if (moduleToCopyright != null) {
            for (Element element : moduleToCopyright.getChildren(ELEMENT)) {
                this.myModuleToCopyrights.put(element.getAttributeValue(MODULE), element.getAttributeValue(COPYRIGHT));
            }
        }
        try {
            for (Element element : state.getChildren(COPYRIGHT)) {
                CopyrightProfile copyrightProfile = new CopyrightProfile();
                copyrightProfile.readExternal(element);
                this.myCopyrights.put(copyrightProfile.getName(), copyrightProfile);
            }
            this.myDefaultCopyright = this.myCopyrights.get(StringUtil.notNullize((String)state.getAttributeValue(DEFAULT)));
            this.myOptions.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public Map<String, String> getCopyrightsMapping() {
        return this.myModuleToCopyrights;
    }

    public void setDefaultCopyright(@Nullable CopyrightProfile copyright) {
        this.myDefaultCopyright = copyright;
    }

    @Nullable
    public CopyrightProfile getDefaultCopyright() {
        return this.myDefaultCopyright;
    }

    public void addCopyright(CopyrightProfile copyrightProfile) {
        this.myCopyrights.put(copyrightProfile.getName(), copyrightProfile);
    }

    public void removeCopyright(CopyrightProfile copyrightProfile) {
        this.myCopyrights.values().remove((Object)copyrightProfile);
        Iterator<String> it = this.myModuleToCopyrights.keySet().iterator();
        while (it.hasNext()) {
            String profileName = this.myModuleToCopyrights.get(it.next());
            if (!profileName.equals(copyrightProfile.getName())) continue;
            it.remove();
        }
    }

    public void clearCopyrights() {
        this.myDefaultCopyright = null;
        this.myCopyrights.clear();
        this.myModuleToCopyrights.clear();
    }

    public void mapCopyright(String scopeName, String copyrightProfileName) {
        this.myModuleToCopyrights.put(scopeName, copyrightProfileName);
    }

    public void unmapCopyright(String scopeName) {
        this.myModuleToCopyrights.remove(scopeName);
    }

    public Collection<CopyrightProfile> getCopyrights() {
        return this.myCopyrights.values();
    }

    public boolean hasAnyCopyrights() {
        return this.myDefaultCopyright != null || !this.myModuleToCopyrights.isEmpty();
    }

    @Nullable
    public CopyrightProfile getCopyrightOptions(@NotNull PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || this.myOptions.getOptions(virtualFile.getFileType().getName()).getFileTypeOverride() == 1) {
            return null;
        }
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        for (String scopeName : this.myModuleToCopyrights.keySet()) {
            CopyrightProfile profile;
            PackageSet packageSet;
            NamedScope namedScope = validationManager.getScope(scopeName);
            if (namedScope == null || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file, (NamedScopesHolder)validationManager) || (profile = this.myCopyrights.get(this.myModuleToCopyrights.get(scopeName))) == null) continue;
            return profile;
        }
        return this.myDefaultCopyright != null ? this.myDefaultCopyright : null;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    public void replaceCopyright(String displayName, CopyrightProfile copyrightProfile) {
        if (this.myDefaultCopyright != null && Comparing.strEqual((String)this.myDefaultCopyright.getName(), (String)displayName)) {
            this.myDefaultCopyright = copyrightProfile;
        }
        this.myCopyrights.remove(displayName);
        this.addCopyright(copyrightProfile);
    }

    static final class CopyrightStateSplitter
    extends MainConfigurationStateSplitter {
        CopyrightStateSplitter() {
        }

        @NotNull
        protected String getComponentStateFileName() {
            return "profiles_settings";
        }

        @NotNull
        protected String getSubStateTagName() {
            return CopyrightManager.COPYRIGHT;
        }
    }
}

