/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeBinarySpec;

public class StlConfiguration {
    public static void createStlCopyTask(ModelMap<Task> tasks, NativeBinarySpec binary, File buildDir, NdkHandler ndkHandler, Stl stl, String stlVersion, String buildTaskName) {
        if (!stl.isStatic()) {
            Abi abi = Abi.getByName((String)binary.getTargetPlatform().getName());
            StlNativeToolSpecification stlConfig = ndkHandler.getStlNativeToolSpecification(stl, stlVersion, abi);
            String copyTaskName = NdkNamingScheme.getTaskName(binary, "copy", "StlSo");
            tasks.create(copyTaskName, Copy.class, copy -> {
                copy.from(new Object[]{stlConfig.getSharedLibs()});
                copy.into((Object)new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName(binary)));
            });
            tasks.named(buildTaskName, task -> task.dependsOn(new Object[]{copyTaskName}));
        }
    }
}

