/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceDeleter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final boolean[] delete;

    public InterfaceDeleter(boolean[] delete) {
        this.delete = delete;
    }

    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        int newInterfacesCount = 0;
        for (int index = 0; index < interfacesCount; ++index) {
            if (this.delete[index]) continue;
            interfaces[newInterfacesCount++] = interfaces[index];
        }
        if (newInterfacesCount < interfacesCount) {
            programClass.u2interfacesCount = newInterfacesCount;
            programClass.attributesAccept(this);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        Object[] referencedClasses = signatureAttribute.referencedClasses;
        if (referencedClasses != null) {
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signatureAttribute.getSignature(clazz));
            StringBuffer newSignatureBuffer = new StringBuffer();
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String internalType = internalTypeEnumeration.nextType();
                newSignatureBuffer.append(internalType);
                int classCount = new DescriptorClassEnumeration(internalType).classCount();
                for (int counter = 0; counter < classCount; ++counter) {
                    referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                }
                if (!ClassUtil.isInternalClassType(internalType)) continue;
                break;
            }
            int index = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String internalType = internalTypeEnumeration.nextType();
                int classCount = new DescriptorClassEnumeration(internalType).classCount();
                if (!this.delete[index++]) {
                    newSignatureBuffer.append(internalType);
                    for (int counter = 0; counter < classCount; ++counter) {
                        referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                    }
                    continue;
                }
                referencedClassIndex += classCount;
            }
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            Arrays.fill(referencedClasses, newReferencedClassIndex, referencedClassIndex, null);
        }
    }
}

