/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberTableAttribute
extends Attribute {
    public int u2lineNumberTableLength;
    public LineNumberInfo[] lineNumberTable;

    public LineNumberTableAttribute() {
    }

    public LineNumberTableAttribute(int u2attributeNameIndex, int u2lineNumberTableLength, LineNumberInfo[] lineNumberTable) {
        super(u2attributeNameIndex);
        this.u2lineNumberTableLength = u2lineNumberTableLength;
        this.lineNumberTable = lineNumberTable;
    }

    public int getLineNumber(int pc) {
        for (int index = this.u2lineNumberTableLength - 1; index >= 0; --index) {
            LineNumberInfo info = this.lineNumberTable[index];
            if (pc < info.u2startPC) continue;
            return info.u2lineNumber;
        }
        return this.u2lineNumberTableLength > 0 ? this.lineNumberTable[0].u2lineNumber : 0;
    }

    public int getLowestLineNumber() {
        if (this.u2lineNumberTableLength == 0) {
            return 0;
        }
        int lowestLineNumber = Integer.MAX_VALUE;
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            int lineNumber = this.lineNumberTable[index].u2lineNumber;
            if (lineNumber >= lowestLineNumber) continue;
            lowestLineNumber = lineNumber;
        }
        return lowestLineNumber;
    }

    public int getHighestLineNumber() {
        if (this.u2lineNumberTableLength == 0) {
            return 0;
        }
        int highestLineNumber = Integer.MIN_VALUE;
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            int lineNumber = this.lineNumberTable[index].u2lineNumber;
            if (lineNumber <= highestLineNumber) continue;
            highestLineNumber = lineNumber;
        }
        return highestLineNumber;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitLineNumberTableAttribute(clazz, method, codeAttribute, this);
    }

    public void lineNumbersAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfoVisitor lineNumberInfoVisitor) {
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            lineNumberInfoVisitor.visitLineNumberInfo(clazz, method, codeAttribute, this.lineNumberTable[index]);
        }
    }
}

