/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.installer.SdkInstallerUtil;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SdkDownloader {
    public static void main(String[] args) {
        Settings settings = Settings.createSettings(args);
        if (settings == null) {
            SdkDownloader.usageAndExit();
        }
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler handler = AndroidSdkHandler.getInstance(settings.getLocalPath());
        RepoManager mgr = handler.getSdkManager((ProgressIndicator)progress);
        if (settings.isInstallAction()) {
            SdkDownloader.installPackages(settings, progress, handler, mgr);
        } else {
            SdkDownloader.uninstallPackages(settings, progress, handler, mgr);
        }
        progress.logInfo("done");
    }

    private static void installPackages(Settings settings, ConsoleProgressIndicator progress, AndroidSdkHandler handler, RepoManager mgr) {
        LegacyDownloader downloader = new LegacyDownloader(handler.getFileOp());
        mgr.loadSynchronously(0L, (ProgressIndicator)progress, (Downloader)downloader, (SettingsController)settings);
        List<RemotePackage> remotes = Lists.newArrayList();
        for (String path : settings.getPaths(mgr)) {
            RemotePackage p = (RemotePackage)mgr.getPackages().getRemotePackages().get(path);
            if (p == null) {
                progress.logError("Failed to find package " + path);
                SdkDownloader.usageAndExit();
            }
            remotes.add(p);
        }
        if ((remotes = InstallerUtil.computeRequiredPackages((Collection)remotes, (RepositoryPackages)mgr.getPackages(), (ProgressIndicator)progress)) != null) {
            for (RemotePackage p : remotes) {
                License l = p.getLicense();
                if (l != null && !l.checkAccepted(handler.getLocation(), handler.getFileOp())) {
                    progress.logError(String.format("License for %1$s (%2$s) is not accepted. Please install using studio, then copy <studio sdk path>/licenses/* to %3$s/licenses/", p.getDisplayName(), p.getPath(), handler.getLocation()));
                    System.exit(1);
                }
                Installer installer = SdkInstallerUtil.findBestInstallerFactory((RepoPackage)p, handler).createInstaller(p, mgr, (Downloader)downloader, handler.getFileOp());
                SdkDownloader.applyPackageOperation((PackageOperation)installer, progress);
            }
        } else {
            progress.logError("Unable to compute a complete list of dependencies.");
        }
    }

    private static void uninstallPackages(Settings settings, ConsoleProgressIndicator progress, AndroidSdkHandler handler, RepoManager mgr) {
        mgr.loadSynchronously(0L, (ProgressIndicator)progress, null, (SettingsController)settings);
        for (String path : settings.getPaths(mgr)) {
            LocalPackage p = (LocalPackage)mgr.getPackages().getLocalPackages().get(path);
            if (p == null) {
                progress.logWarning("Unable to find package " + path);
                continue;
            }
            Uninstaller uninstaller = SdkInstallerUtil.findBestInstallerFactory((RepoPackage)p, handler).createUninstaller(p, mgr, handler.getFileOp());
            SdkDownloader.applyPackageOperation((PackageOperation)uninstaller, progress);
        }
    }

    private static void applyPackageOperation(PackageOperation operation, ConsoleProgressIndicator progress) {
        if (!operation.prepare((ProgressIndicator)progress)) {
            System.exit(1);
        }
        if (!operation.complete((ProgressIndicator)progress)) {
            System.exit(1);
        }
    }

    private static void usageAndExit() {
        System.out.println("Usage: java com.android.sdklib.tool.SdkDownloader [--uninstall] [--channel=channelId] <sdk path> <package path> <package path>...\n    <package path> is a sdk-style path (e.g. build-tools;23.0.0 or platforms;android-23)\n    channelId is the id of the least stable channel to check.");
        System.exit(1);
    }

    private static class Settings
    implements SettingsController {
        private static final String CHANNEL_ARG = "--channel=";
        private static final String UNINSTALL_ARG = "--uninstall";
        private static final String UPDATE_ARG = "--update";
        private File mLocalPath;
        private List<String> mPackages = new ArrayList<String>();
        private int mChannel = 0;
        private boolean mIsInstall = true;
        private boolean mIsUpdate = false;

        public static Settings createSettings(String[] args) {
            Settings result = new Settings();
            for (String arg : args) {
                if (arg.equals(UNINSTALL_ARG)) {
                    result.mIsInstall = false;
                    continue;
                }
                if (arg.equals(UPDATE_ARG)) {
                    result.mIsUpdate = true;
                    continue;
                }
                if (arg.startsWith(CHANNEL_ARG)) {
                    try {
                        result.mChannel = Integer.parseInt(arg.substring(CHANNEL_ARG.length()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                if (result.mLocalPath == null) {
                    File path = new File(arg);
                    ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
                    if (!path.exists() && !path.mkdirs()) {
                        progress.logError("Failed to create SDK root dir: " + path);
                        return null;
                    }
                    result.mLocalPath = path;
                    continue;
                }
                result.mPackages.add(arg);
            }
            if (result.mLocalPath == null || result.mPackages.isEmpty() && !result.mIsUpdate) {
                return null;
            }
            return result;
        }

        public Channel getChannel() {
            return Channel.create((int)this.mChannel);
        }

        public boolean getForceHttp() {
            return false;
        }

        public void setForceHttp(boolean force) {
        }

        public List<String> getPaths(RepoManager mgr) {
            if (this.mIsUpdate) {
                return mgr.getPackages().getUpdatedPkgs().stream().map(p -> p.getRepresentative().getPath()).collect(Collectors.toList());
            }
            return this.mPackages;
        }

        public File getLocalPath() {
            return this.mLocalPath;
        }

        public boolean isInstallAction() {
            return this.mIsInstall;
        }

        private Settings() {
        }
    }
}

