/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgStatusWidget
extends DvcsStatusWidget<HgRepository> {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings myProjectSettings;

    public HgStatusWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings) {
        super(project, "Hg");
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
    }

    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, (Project)ObjectUtils.assertNotNull((Object)this.getProject()), this.myProjectSettings);
    }

    @Nullable
    protected HgRepository guessCurrentRepository(@NotNull Project project) {
        return (HgRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)HgUtil.getRepositoryManager(project), (String)HgProjectSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    protected String getFullBranchName(@NotNull HgRepository repository) {
        return HgUtil.getDisplayableBranchOrBookmarkText(repository);
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        return HgUtil.getRepositoryManager(project).moreThanOneRoot();
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull HgRepository repository) {
        return HgBranchPopup.getInstance(project, repository).asListPopup();
    }

    protected void subscribeToRepoChangeEvents(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                HgStatusWidget.this.updateLater();
            }
        });
    }

    protected void rememberRecentRoot(@NotNull String path) {
        this.myProjectSettings.setRecentRootPath(path);
    }
}

