/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.util.HgUtil;

public class HgDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<HgFileRevision> {
    private static final Logger LOG = Logger.getInstance(HgDiffFromHistoryHandler.class);

    public HgDiffFromHistoryHandler(@NotNull Project project) {
        super(project);
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull HgFileRevision rev1, @Nullable HgFileRevision rev2) {
        return this.executeDiff(path, rev1, rev2);
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull HgFileRevision rev) throws VcsException {
        return this.executeDiff(path, null, rev);
    }

    @NotNull
    protected String getPresentableName(@NotNull HgFileRevision revision) {
        return revision.getRevisionNumber().getChangeset();
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @Nullable HgFileRevision rev1, @Nullable HgFileRevision rev2) {
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        LOG.assertTrue(root != null, (Object)("Repository is null for " + path));
        return HgUtil.getDiff(this.myProject, root, path, rev1 != null ? rev1.getRevisionNumber() : null, rev2 != null ? rev2.getRevisionNumber() : null);
    }
}

