/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.provider.HgCommittedChangeList;
import org.zmlx.hg4idea.provider.HgRepositoryLocation;
import org.zmlx.hg4idea.ui.HgVersionFilterComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCachingCommittedChangesProvider
implements CachingCommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private final Project project;
    private final HgVcs myVcs;
    public static final int VERSION_WITH_REPOSITORY_BRANCHES = 2;
    private static final Comparator<HgCommittedChangeList> BRANCH_COLUMN_COMPARATOR = new Comparator<HgCommittedChangeList>(){

        @Override
        public int compare(HgCommittedChangeList o1, HgCommittedChangeList o2) {
            return Comparing.compare((Comparable)((Object)o1.getBranch()), (Comparable)((Object)o2.getBranch()));
        }
    };
    private static final ChangeListColumn<HgCommittedChangeList> BRANCH_COLUMN = new ChangeListColumn<HgCommittedChangeList>(){

        public String getTitle() {
            return HgVcsMessages.message("hg4idea.changelist.column.branch", new Object[0]);
        }

        public Object getValue(HgCommittedChangeList changeList) {
            String branch = changeList.getBranch();
            return branch.isEmpty() ? "default" : branch;
        }

        @Nullable
        public Comparator<HgCommittedChangeList> getComparator() {
            return BRANCH_COLUMN_COMPARATOR;
        }
    };

    public HgCachingCommittedChangesProvider(Project project, HgVcs vcs) {
        this.project = project;
        this.myVcs = vcs;
    }

    public int getFormatVersion() {
        return 2;
    }

    public CommittedChangeList readChangeList(RepositoryLocation repositoryLocation, DataInput dataInput) throws IOException {
        HgRevisionNumber revision = HgRevisionNumber.getInstance(dataInput.readUTF(), dataInput.readUTF());
        String branch = dataInput.readUTF();
        String committerName = dataInput.readUTF();
        String comment = dataInput.readUTF();
        Date commitDate = new Date(dataInput.readLong());
        int changesCount = dataInput.readInt();
        ArrayList<Change> changes = new ArrayList<Change>();
        for (int i = 0; i < changesCount; ++i) {
            HgContentRevision beforeRevision = this.readRevision(repositoryLocation, dataInput);
            HgContentRevision afterRevision = this.readRevision(repositoryLocation, dataInput);
            changes.add(new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision));
        }
        return new HgCommittedChangeList(this.myVcs, revision, branch, comment, committerName, commitDate, changes);
    }

    public void writeChangeList(DataOutput dataOutput, CommittedChangeList committedChangeList) throws IOException {
        HgCommittedChangeList changeList = (HgCommittedChangeList)committedChangeList;
        this.writeRevisionNumber(dataOutput, changeList.getRevisionNumber());
        dataOutput.writeUTF(changeList.getBranch());
        dataOutput.writeUTF(changeList.getCommitterName());
        dataOutput.writeUTF(changeList.getComment());
        dataOutput.writeLong(changeList.getCommitDate().getTime());
        dataOutput.writeInt(changeList.getChanges().size());
        for (Change change : changeList.getChanges()) {
            this.writeRevision(dataOutput, (HgContentRevision)change.getBeforeRevision());
            this.writeRevision(dataOutput, (HgContentRevision)change.getAfterRevision());
        }
    }

    private HgContentRevision readRevision(RepositoryLocation repositoryLocation, DataInput dataInput) throws IOException {
        String revisionPath = dataInput.readUTF();
        HgRevisionNumber revisionNumber = this.readRevisionNumber(dataInput);
        if (!StringUtil.isEmpty((String)revisionPath)) {
            VirtualFile root = ((HgRepositoryLocation)repositoryLocation).getRoot();
            return HgContentRevision.create(this.project, new HgFile(root, new File(revisionPath)), revisionNumber);
        }
        return null;
    }

    private void writeRevision(DataOutput dataOutput, HgContentRevision revision) throws IOException {
        if (revision == null) {
            dataOutput.writeUTF("");
            this.writeRevisionNumber(dataOutput, HgRevisionNumber.getInstance("", ""));
        } else {
            dataOutput.writeUTF(revision.getFile().getIOFile().toString());
            this.writeRevisionNumber(dataOutput, revision.getRevisionNumber());
        }
    }

    private HgRevisionNumber readRevisionNumber(DataInput dataInput) throws IOException {
        String revisionRevision = dataInput.readUTF();
        String revisionChangeset = dataInput.readUTF();
        return HgRevisionNumber.getInstance(revisionRevision, revisionChangeset);
    }

    private void writeRevisionNumber(DataOutput dataOutput, HgRevisionNumber revisionNumber) throws IOException {
        dataOutput.writeUTF(revisionNumber.getRevision());
        dataOutput.writeUTF(revisionNumber.getChangeset());
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation repositoryLocation) throws VcsException {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    @Nls
    public String getChangelistTitle() {
        return null;
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, CommittedChangeList committedChangeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return false;
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        return new ChangeBrowserSettings();
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new HgVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(FilePath filePath) {
        VirtualFile repo = VcsUtil.getVcsRootFor((Project)this.project, (FilePath)filePath);
        if (repo == null) {
            return null;
        }
        return new HgRepositoryLocation(repo.getUrl(), repo);
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings changeBrowserSettings, RepositoryLocation repositoryLocation, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            List<CommittedChangeList> results = this.getCommittedChanges(changeBrowserSettings, repositoryLocation, maxCount);
            for (CommittedChangeList result : results) {
                consumer.consume((Object)result);
            }
        }
        finally {
            consumer.finished();
        }
    }

    public List<CommittedChangeList> getCommittedChanges(ChangeBrowserSettings changeBrowserSettings, RepositoryLocation repositoryLocation, int maxCount) throws VcsException {
        HgLogArgsBuilder argsBuilder;
        VirtualFile root = ((HgRepositoryLocation)repositoryLocation).getRoot();
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        LinkedList<CommittedChangeList> result = new LinkedList<CommittedChangeList>();
        HgLogCommand hgLogCommand = new HgLogCommand(this.project);
        hgLogCommand.setLogFile(false);
        List<String> args = null;
        if (changeBrowserSettings != null && (args = (argsBuilder = new HgLogArgsBuilder(changeBrowserSettings)).getLogArgs()).isEmpty()) {
            maxCount = maxCount == 0 ? VcsConfiguration.getInstance((Project)this.project).MAXIMUM_HISTORY_ROWS : maxCount;
        }
        List<HgFileRevision> localRevisions = hgLogCommand.execute(hgFile, maxCount == 0 ? -1 : maxCount, true, args);
        Collections.reverse(localRevisions);
        for (HgFileRevision revision : localRevisions) {
            HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
            List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
            HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
            ArrayList<Change> changes = new ArrayList<Change>();
            for (String string : revision.getModifiedFiles()) {
                changes.add(this.createChange(root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
            }
            for (String string : revision.getAddedFiles()) {
                changes.add(this.createChange(root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
            }
            for (String string : revision.getDeletedFiles()) {
                changes.add(this.createChange(root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
            }
            for (Map.Entry entry : revision.getMovedFiles().entrySet()) {
                changes.add(this.createChange(root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, HgChangeProvider.RENAMED));
            }
            result.add((CommittedChangeList)new HgCommittedChangeList(this.myVcs, vcsRevisionNumber, revision.getBranchName(), revision.getCommitMessage(), revision.getAuthor(), revision.getRevisionDate(), changes));
        }
        Collections.reverse(result);
        return result;
    }

    private Change createChange(VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        HgContentRevision beforeRevision = fileBefore == null ? null : HgContentRevision.create(this.project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        HgContentRevision afterRevision = fileAfter == null ? null : HgContentRevision.create(this.project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        return new Change(beforeRevision, afterRevision, aStatus);
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{BRANCH_COLUMN, ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
    }

    public VcsCommittedViewAuxiliary createActions(DecoratorManager decoratorManager, RepositoryLocation repositoryLocation) {
        AnAction copyHashAction = new AnAction("Copy &Hash", "Copy hash to clipboard", PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
                if (changeLists != null && changeLists[0] instanceof HgCommittedChangeList) {
                    HgRevisionNumber revisionNumber = ((HgCommittedChangeList)changeLists[0]).getRevisionNumber();
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(revisionNumber.getChangeset()));
                }
            }
        };
        return new VcsCommittedViewAuxiliary(Collections.singletonList(copyHashAction), new Runnable(){

            @Override
            public void run() {
            }
        }, Collections.singletonList(copyHashAction));
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    public Pair<CommittedChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        ChangeBrowserSettings settings = this.createDefaultSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_AFTER = number.asString();
        settings.CHANGE_BEFORE = number.asString();
        VirtualFile localVirtualFile = HgUtil.convertToLocalVirtualFile(file);
        if (localVirtualFile == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)localVirtualFile);
        CommittedChangeList list = this.getCommittedChangesForRevision(this.getLocationFor(filePath), number.asString());
        if (list != null) {
            return new Pair((Object)list, (Object)filePath);
        }
        return null;
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return false;
    }

    @Nullable
    public CommittedChangeList getCommittedChangesForRevision(@Nullable RepositoryLocation repositoryLocation, String revision) {
        if (repositoryLocation == null) {
            return null;
        }
        VirtualFile root = ((HgRepositoryLocation)repositoryLocation).getRoot();
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        HgLogCommand hgLogCommand = new HgLogCommand(this.project);
        hgLogCommand.setLogFile(false);
        hgLogCommand.setFollowCopies(true);
        ArrayList<String> args = new ArrayList<String>();
        args.add("--rev");
        args.add(revision);
        List<HgFileRevision> revisions = hgLogCommand.execute(hgFile, 1, true, args);
        if (ContainerUtil.isEmpty(revisions)) {
            return null;
        }
        HgFileRevision localRevision = revisions.get(0);
        HgRevisionNumber vcsRevisionNumber = localRevision.getRevisionNumber();
        List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
        HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (String string : localRevision.getModifiedFiles()) {
            changes.add(this.createChange(root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
        }
        for (String string : localRevision.getAddedFiles()) {
            changes.add(this.createChange(root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
        }
        for (String string : localRevision.getDeletedFiles()) {
            changes.add(this.createChange(root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
        }
        for (Map.Entry entry : localRevision.getMovedFiles().entrySet()) {
            changes.add(this.createChange(root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, HgChangeProvider.RENAMED));
        }
        return new HgCommittedChangeList(this.myVcs, vcsRevisionNumber, localRevision.getBranchName(), localRevision.getCommitMessage(), localRevision.getAuthor(), localRevision.getRevisionDate(), changes);
    }

    private static class HgLogArgsBuilder {
        @NotNull
        private final ChangeBrowserSettings myBrowserSettings;

        HgLogArgsBuilder(@NotNull ChangeBrowserSettings browserSettings) {
            this.myBrowserSettings = browserSettings;
        }

        @NotNull
        List<String> getLogArgs() {
            StringBuilder args = new StringBuilder();
            Date afterDate = this.myBrowserSettings.getDateAfter();
            Date beforeDate = this.myBrowserSettings.getDateBefore();
            Long afterFilter = this.myBrowserSettings.getChangeAfterFilter();
            Long beforeFilter = this.myBrowserSettings.getChangeBeforeFilter();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            if (afterFilter != null && beforeFilter != null) {
                args.append(afterFilter).append(":").append(beforeFilter);
            } else if (afterFilter != null) {
                args.append("tip:").append(afterFilter);
            } else if (beforeFilter != null) {
                args.append("reverse(:").append(beforeFilter).append(")");
            }
            if (afterDate != null) {
                if (args.length() > 0) {
                    args.append(" and ");
                }
                args.append("date('>").append(dateFormatter.format(afterDate)).append("')");
            }
            if (beforeDate != null) {
                if (args.length() > 0) {
                    args.append(" and ");
                }
                args.append("date('<").append(dateFormatter.format(beforeDate)).append("')");
            }
            if (args.length() > 0) {
                ArrayList<String> logArgs = new ArrayList<String>();
                logArgs.add("-r");
                logArgs.add(args.toString());
                return logArgs;
            }
            return Collections.emptyList();
        }
    }
}

