/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public abstract class HgBaseLogParser<CommitT>
implements Function<String, CommitT> {
    private static final Logger LOG = Logger.getInstance(HgBaseLogParser.class);
    private static final int REVISION_INDEX = 0;
    private static final int CHANGESET_INDEX = 1;
    private static final int PARENTS_INDEX = 2;
    private static final int DATE_INDEX = 3;
    private static final int AUTHOR_INDEX = 4;
    protected static final int MESSAGE_INDEX = 5;
    protected static final int BRANCH_INDEX = 6;
    protected static final int FILES_ADDED_INDEX = 7;
    protected static final int FILES_MODIFIED_INDEX = 8;
    protected static final int FILES_DELETED_INDEX = 9;
    protected static final int FILES_COPIED_INDEX = 10;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    @Nullable
    public CommitT convert(@NotNull String line) {
        List attributes = StringUtil.split((String)line, (String)"\u0017", (boolean)true, (boolean)false);
        int numAttributes = attributes.size();
        if (numAttributes <= 4) {
            LOG.info("Hg Log Command was cancelled or failed");
            return null;
        }
        try {
            String revisionString = (String)attributes.get(0);
            String changeset = (String)attributes.get(1);
            String parentsString = (String)attributes.get(2);
            SmartList<HgRevisionNumber> parents = HgBaseLogParser.parseParentRevisions(parentsString, revisionString);
            Date revisionDate = DATE_FORMAT.parse((String)attributes.get(3));
            Couple<String> authorAndEmail = HgUtil.parseUserNameAndEmail((String)attributes.get(4));
            return this.convertDetails(revisionString, changeset, parents, revisionDate, (String)authorAndEmail.first, (String)authorAndEmail.second, attributes);
        }
        catch (ParseException e) {
            LOG.warn("Error parsing date in line " + line);
            return null;
        }
        catch (NumberFormatException e) {
            LOG.warn("Error parsing rev in line " + line);
            return null;
        }
    }

    public CommitT fun(String s) {
        return this.convert(s);
    }

    @Nullable
    protected abstract CommitT convertDetails(@NotNull String var1, @NotNull String var2, @NotNull SmartList<HgRevisionNumber> var3, @NotNull Date var4, @NotNull String var5, @NotNull String var6, @NotNull List<String> var7);

    @NotNull
    public static List<String> constructDefaultTemplate(HgVersion currentVersion) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|isodatesec}", "{author}"));
        return templates;
    }

    @NotNull
    public static String[] constructFullTemplateArgument(boolean includeFiles, @NotNull HgVersion currentVersion) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|isodatesec}", "{author}", "{desc}", "{branch}"));
        if (!includeFiles) {
            return ArrayUtil.toStringArray(templates);
        }
        ArrayList fileTemplates = ContainerUtil.newArrayList((Object[])new String[]{"file_adds", "file_mods", "file_dels", "file_copies"});
        templates.addAll(HgBaseLogParser.wrapIn(fileTemplates, currentVersion));
        return ArrayUtil.toStringArray(templates);
    }

    @NotNull
    private static List<String> wrapIn(@NotNull List<String> fileTemplates, @NotNull HgVersion currentVersion) {
        final boolean supported = currentVersion.isBuiltInFunctionSupported();
        return ContainerUtil.map(fileTemplates, (Function)new Function<String, String>(){

            public String fun(String s) {
                return supported ? "{join(" + s + ",'" + "\u0001" + "')}" : "{" + s + "}";
            }
        });
    }

    @NotNull
    protected static SmartList<HgRevisionNumber> parseParentRevisions(@NotNull String parentsString, @NotNull String currentRevisionString) {
        SmartList parents = new SmartList();
        if (StringUtil.isEmptyOrSpaces((String)parentsString)) {
            Long revision = Long.valueOf(currentRevisionString);
            HgRevisionNumber parentRevision = HgRevisionNumber.getLocalInstance(String.valueOf(revision - 1L));
            parents.add((Object)parentRevision);
            return parents;
        }
        List parentStrings = StringUtil.split((String)parentsString.trim(), (String)" ");
        for (String parentString : parentStrings) {
            List parentParts = StringUtil.split((String)parentString, (String)":");
            if (Integer.valueOf((String)parentParts.get(0)) < 0) continue;
            parents.add((Object)HgRevisionNumber.getInstance((String)parentParts.get(0), (String)parentParts.get(1)));
        }
        return parents;
    }

    @NotNull
    protected static String parseAdditionalStringAttribute(List<String> attributes, int index) {
        int numAttributes = attributes.size();
        if (numAttributes > index) {
            return attributes.get(index);
        }
        LOG.warn("Couldn't parse hg log commit info attribute " + index);
        return "";
    }

    @NotNull
    public static String extractSubject(@NotNull String message) {
        int subjectIndex = message.indexOf(10);
        return subjectIndex == -1 ? message : message.substring(0, subjectIndex);
    }
}

