/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQFinishCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQFinishCommand(@NotNull HgRepository repository) {
        this.myRepository = repository;
    }

    public void execute(@NotNull String revision) {
        final Project project = this.myRepository.getProject();
        new HgCommandExecutor(project).execute(this.myRepository.getRoot(), "qfinish", Collections.singletonList("qbase:" + revision), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "QFinish command failed", "Could not apply patches into repository history.");
                }
                HgQFinishCommand.this.myRepository.update();
            }
        });
    }
}

