/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCherryPicker
extends VcsCherryPicker {
    @NotNull
    private final Project myProject;

    public HgCherryPicker(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return HgVcs.getKey();
    }

    @NotNull
    public String getActionTitle() {
        return "Graft";
    }

    public void cherryPick(@NotNull List<VcsFullCommitDetails> commits) {
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots((RepositoryManager)HgUtil.getRepositoryManager(this.myProject), commits);
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            HgCherryPicker.processGrafting((HgRepository)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)new Function<VcsFullCommitDetails, String>(){

                public String fun(VcsFullCommitDetails commitDetails) {
                    return ((Hash)commitDetails.getId()).asString();
                }
            }));
        }
    }

    private static void processGrafting(@NotNull HgRepository repository, @NotNull List<String> hashes) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        HgGraftCommand command = new HgGraftCommand(project, repository);
        HgCommandResult result = command.startGrafting(hashes);
        boolean hasConflicts = HgConflictResolver.hasConflicts(project, root);
        if (!hasConflicts && HgErrorUtil.isCommandExecutionFailed(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't  graft.");
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        while (hasConflicts) {
            new HgConflictResolver(project, updatedFiles).resolve(root);
            hasConflicts = HgConflictResolver.hasConflicts(project, root);
            if (!hasConflicts) {
                result = command.continueGrafting();
                hasConflicts = HgConflictResolver.hasConflicts(project, root);
                continue;
            }
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't continue grafting");
            break;
        }
        repository.update();
        root.refresh(true, true);
    }

    public boolean isEnabled(@NotNull VcsLog log, @NotNull Map<VirtualFile, List<Hash>> commits) {
        if (commits.isEmpty()) {
            return false;
        }
        for (VirtualFile root : commits.keySet()) {
            HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            if (repository != null) continue;
            return false;
        }
        return true;
    }
}

