/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopup
extends DvcsBranchPopup<HgRepository> {
    public static HgBranchPopup getInstance(@NotNull Project project, @NotNull HgRepository currentRepository) {
        HgRepositoryManager manager = HgUtil.getRepositoryManager(project);
        HgProjectSettings hgProjectSettings = (HgProjectSettings)ServiceManager.getService((Project)project, HgProjectSettings.class);
        HgMultiRootBranchConfig hgMultiRootBranchConfig = new HgMultiRootBranchConfig(manager.getRepositories());
        Condition<AnAction> preselectActionCondition = new Condition<AnAction>(){

            public boolean value(AnAction action) {
                return false;
            }
        };
        return new HgBranchPopup(currentRepository, manager, hgMultiRootBranchConfig, hgProjectSettings, preselectActionCondition);
    }

    private HgBranchPopup(@NotNull HgRepository currentRepository, @NotNull HgRepositoryManager repositoryManager, @NotNull HgMultiRootBranchConfig hgMultiRootBranchConfig, @NotNull HgProjectSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)hgMultiRootBranchConfig, (DvcsSyncSettings)vcsSettings, preselectActionCondition);
    }

    protected void setCurrentBranchInfo() {
        String branchText = "Current branch : ";
        this.myPopup.setAdText(branchText + ((HgRepository)this.myCurrentRepository).getCurrentBranch(), 0);
    }

    protected void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup popupGroup, @NotNull AbstractRepositoryManager<HgRepository> repositoryManager) {
        List repositories;
        List allRepositories = repositoryManager.getRepositories();
        popupGroup.add((AnAction)new HgBranchPopupActions.HgNewBranchAction(this.myProject, allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgNewBookmarkAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgCloseBranchAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgShowUnnamedHeadsForCurrentBranchAction((HgRepository)this.myCurrentRepository));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Branches");
        for (String branch : this.myMultiRootBranchConfig.getLocalBranchNames()) {
            repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories);
            if (repositories.isEmpty()) continue;
            popupGroup.add((AnAction)new HgCommonBranchActions(this.myProject, repositories, branch));
        }
        popupGroup.addSeparator("Common Bookmarks");
        for (String branch : ((HgMultiRootBranchConfig)this.myMultiRootBranchConfig).getBookmarkNames()) {
            repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories);
            if (repositories.isEmpty()) continue;
            popupGroup.add((AnAction)new HgBranchPopupActions.BookmarkActions(this.myProject, repositories, branch));
        }
    }

    @NotNull
    protected DefaultActionGroup createRepositoriesActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addSeparator("Repositories");
        for (HgRepository repository : DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories())) {
            popupGroup.add((AnAction)new RootAction((Repository)repository, (Repository)(this.highlightCurrentRepo() ? (HgRepository)this.myCurrentRepository : null), new HgBranchPopupActions(repository.getProject(), repository).createActions(null), HgUtil.getDisplayableBranchOrBookmarkText(repository)));
        }
        return popupGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup popupGroup, @Nullable DefaultActionGroup actions) {
        popupGroup.addAll(new HgBranchPopupActions(this.myProject, (HgRepository)this.myCurrentRepository).createActions(actions));
    }
}

