/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgLogSingleCommitAction;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCreateNewBranchFromLogAction
extends HgLogSingleCommitAction {
    protected void actionPerformed(final @NotNull HgRepository repository, final @NotNull Hash commit) {
        final Project project = repository.getProject();
        FileDocumentManager.getInstance().saveAllDocuments();
        String shortHash = commit.toShortString();
        final String name = HgUtil.getNewBranchNameFromUser(repository, "Create New Branch From " + shortHash);
        if (name != null) {
            new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.updatingTo", shortHash)){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (HgUpdateCommand.updateRepoToInCurrentThread(project, repository.getRoot(), commit.asString(), false)) {
                        new HgBranchPopupActions.HgNewBranchAction(project, Collections.singletonList(repository), repository).createNewBranch(name);
                    }
                }
            }.queue();
        }
    }
}

