/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class IncrementalSafeguard
extends BaseTask {
    File javaOutputDir;
    protected List<ConfigurableFileTree> source = new ArrayList<ConfigurableFileTree>();
    File generatedOutputDir;

    @OutputDirectory
    File getGeneratedOutputDir() {
        return this.generatedOutputDir;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        ArrayList<ConfigurableFileTree> copy = new ArrayList<ConfigurableFileTree>(this.source);
        return this.getProject().files(new Object[]{copy}).getAsFileTree();
    }

    @TaskAction
    protected void execute(IncrementalTaskInputs inputs) throws IOException {
        this.getLogger().debug("Removing old bits to force javac non incremental mode.");
        File outputFile = new File(this.generatedOutputDir, "tag.txt");
        Files.createParentDirs((File)outputFile);
        Files.write((CharSequence)"incremental task execution", (File)outputFile, (Charset)Charsets.UTF_8);
        try {
            FileUtils.deletePath((File)this.javaOutputDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<IncrementalSafeguard> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("incremental", "JavaCompilationSafeguard");
        }

        @Override
        public Class<IncrementalSafeguard> getType() {
            return IncrementalSafeguard.class;
        }

        @Override
        public void execute(IncrementalSafeguard task) {
            task.setVariantName(this.scope.getVariantConfiguration().getFullName());
            task.javaOutputDir = this.scope.getJavaOutputDir();
            task.generatedOutputDir = new File(this.scope.getGlobalScope().getIntermediatesDir(), "/incremental-safeguard/" + this.scope.getVariantData().getVariantConfiguration().getDirName());
            task.source = this.scope.getVariantData().getGeneratedJavaSources();
        }
    }
}

