/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.OutputFile;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.LoggingUtil;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.model.AndroidLibrary;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class ProcessAndroidResources
extends IncrementalTask {
    private static final Logger LOG = Logging.getLogger(ProcessAndroidResources.class);
    private File manifestFile;
    private File instantRunManifestFile;
    private File resDir;
    private File sourceOutputDir;
    private File textSymbolOutputDir;
    private File packageOutputFile;
    private File proguardOutputFile;
    private File mainDexListProguardOutputFile;
    private Collection<String> resourceConfigs;
    private String preferredDensity;
    private List<AndroidLibrary> libraries;
    private String packageForR;
    private Collection<String> splits;
    private boolean enforceUniquePackageName;
    private VariantType type;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;
    private InstantRunBuildContext instantRunBuildContext;
    private VariantScope variantScope;

    @Override
    protected void doFullTaskAction() throws IOException {
        File srcOut = this.getSourceOutputDir();
        if (srcOut != null) {
            FileUtils.cleanOutputDir((File)srcOut);
        }
        File resOutBaseNameFile = this.getPackageOutputFile();
        File instantRunManifest = this.getInstantRunManifestFile();
        File manifestFileToPackage = this.instantRunBuildContext.isInInstantRunMode() && instantRunManifest != null && instantRunManifest.exists() ? instantRunManifest : this.getManifestFile();
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new AaptOutputParser(), this.getILogger()), new MessageReceiver[]{new MergingLogRewriter(mergingLog, (MessageReceiver)builder.getErrorReporter())});
        try {
            Aapt aapt = AaptGradleFactory.make(this.getBuilder(), (ProcessOutputHandler)processOutputHandler, true, true, this.variantScope.getGlobalScope().getProject(), this.variantScope.getVariantConfiguration().getType(), FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), this.aaptOptions.getCruncherProcesses());
            AaptPackageConfig.Builder config = new AaptPackageConfig.Builder().setManifestFile(manifestFileToPackage).setOptions((com.android.builder.model.AaptOptions)this.getAaptOptions()).setResourceDir(this.getResDir()).setLibraries(this.getLibraries()).setCustomPackageForR(this.getPackageForR()).setSymbolOutputDir(this.getTextSymbolOutputDir()).setSourceOutputDir(srcOut).setResourceOutputApk(resOutBaseNameFile).setProguardOutputFile(this.getProguardOutputFile()).setMainDexListProguardOutputFile(this.getMainDexListProguardOutputFile()).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalize(this.getPseudoLocalesEnabled()).setResourceConfigs(this.getResourceConfigs()).setSplits(this.getSplits()).setPreferredDensity(this.getPreferredDensity());
            builder.processResources(aapt, config, this.getEnforceUniquePackageName());
            if (resOutBaseNameFile != null && LOG.isInfoEnabled()) {
                LOG.info("Aapt output file {}", (Object)resOutBaseNameFile.getAbsolutePath());
            }
        }
        catch (ProcessException | IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @InputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public File getInstantRunManifestFile() {
        return this.instantRunManifestFile;
    }

    public void setInstantRunManifestFile(File manifestFile) {
        this.instantRunManifestFile = manifestFile;
    }

    @Input
    public boolean isInstantRunMode() {
        return this.instantRunBuildContext.isInInstantRunMode();
    }

    @InputDirectory
    public File getResDir() {
        return this.resDir;
    }

    public void setResDir(File resDir) {
        this.resDir = resDir;
    }

    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    @Optional
    public File getTextSymbolOutputDir() {
        return this.textSymbolOutputDir;
    }

    public void setTextSymbolOutputDir(File textSymbolOutputDir) {
        this.textSymbolOutputDir = textSymbolOutputDir;
    }

    @org.gradle.api.tasks.OutputFile
    @Optional
    public File getPackageOutputFile() {
        return this.packageOutputFile;
    }

    public void setPackageOutputFile(File packageOutputFile) {
        this.packageOutputFile = packageOutputFile;
    }

    @org.gradle.api.tasks.OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @org.gradle.api.tasks.OutputFile
    @Optional
    public File getMainDexListProguardOutputFile() {
        return this.mainDexListProguardOutputFile;
    }

    public void setAaptMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
        this.mainDexListProguardOutputFile = mainDexListProguardOutputFile;
    }

    @Input
    public Collection<String> getResourceConfigs() {
        return this.resourceConfigs;
    }

    public void setResourceConfigs(Collection<String> resourceConfigs) {
        this.resourceConfigs = resourceConfigs;
    }

    @Input
    @Optional
    public String getPreferredDensity() {
        return this.preferredDensity;
    }

    public void setPreferredDensity(String preferredDensity) {
        this.preferredDensity = preferredDensity;
    }

    @Input
    String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @Optional
    public List<File> getInputFilesFromLibraries() {
        List<AndroidLibrary> libs = this.getLibraries();
        if (libs == null) {
            return ImmutableList.of();
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)(libs.size() * 2));
        for (AndroidLibrary androidLibrary : libs) {
            files.add(androidLibrary.getManifest());
            files.add(androidLibrary.getSymbolFile());
        }
        return files;
    }

    public List<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    @Input
    @Optional
    public String getPackageForR() {
        return this.packageForR;
    }

    public void setPackageForR(String packageForR) {
        this.packageForR = packageForR;
    }

    @Input
    @Optional
    public Collection<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Collection<String> splits) {
        this.splits = splits;
    }

    @Input
    public boolean getEnforceUniquePackageName() {
        return this.enforceUniquePackageName;
    }

    public void setEnforceUniquePackageName(boolean enforceUniquePackageName) {
        this.enforceUniquePackageName = enforceUniquePackageName;
    }

    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessAndroidResources> {
        private final VariantOutputScope scope;
        private final File symbolLocation;
        private final boolean generateResourcePackage;
        private final boolean generateLegacyMultidexMainDexProguardRules;

        public ConfigAction(VariantOutputScope scope, File symbolLocation, boolean generateResourcePackage, boolean generateLegacyMultidexMainDexProguardRules) {
            this.scope = scope;
            this.symbolLocation = symbolLocation;
            this.generateResourcePackage = generateResourcePackage;
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Resources");
        }

        @Override
        public Class<ProcessAndroidResources> getType() {
            return ProcessAndroidResources.class;
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            final BaseVariantOutputData variantOutputData = this.scope.getVariantOutputData();
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantScope().getVariantData();
            variantOutputData.processResourcesTask = processResources;
            final GradleVariantConfiguration config = variantData.getVariantConfiguration();
            processResources.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processResources.setVariantName(config.getFullName());
            processResources.variantScope = this.scope.getVariantScope();
            processResources.setIncrementalFolder(this.scope.getVariantScope().getIncrementalDir(this.getName()));
            if (variantData.getSplitHandlingPolicy() == SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY) {
                HashSet<String> allFilters = new HashSet<String>();
                allFilters.addAll(variantData.getFilters(OutputFile.FilterType.DENSITY));
                allFilters.addAll(variantData.getFilters(OutputFile.FilterType.LANGUAGE));
                processResources.splits = allFilters;
            }
            if (variantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY) == null && variantData.generateRClassTask == null) {
                variantData.generateRClassTask = processResources;
                processResources.enforceUniquePackageName = this.scope.getGlobalScope().getExtension().getEnforceUniquePackageName();
                ConventionMappingHelper.map((Task)processResources, "libraries", new Callable<List<AndroidLibrary>>(){

                    @Override
                    public List<AndroidLibrary> call() throws Exception {
                        return config.getFlatPackageAndroidLibraries();
                    }
                });
                ConventionMappingHelper.map((Task)processResources, "packageForR", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return config.getOriginalApplicationId();
                    }
                });
                processResources.setSourceOutputDir(this.scope.getVariantScope().getRClassSourceOutputDir());
                processResources.setTextSymbolOutputDir(this.symbolLocation);
                if (((CoreBuildType)config.getBuildType()).isMinifyEnabled()) {
                    if (((CoreBuildType)config.getBuildType()).isShrinkResources() && config.getJackOptions().isEnabled().booleanValue()) {
                        LoggingUtil.displayWarning(Logging.getLogger(this.getClass()), this.scope.getGlobalScope().getProject(), "shrinkResources does not yet work with useJack=true");
                    }
                    processResources.setProguardOutputFile(this.scope.getVariantScope().getProcessAndroidResourcesProguardOutputFile());
                } else if (((CoreBuildType)config.getBuildType()).isShrinkResources()) {
                    LoggingUtil.displayWarning(Logging.getLogger(this.getClass()), this.scope.getGlobalScope().getProject(), "To shrink resources you must also enable ProGuard");
                }
                if (this.generateLegacyMultidexMainDexProguardRules) {
                    processResources.setAaptMainDexListProguardOutputFile(this.scope.getVariantScope().getManifestKeepListProguardFile());
                }
            }
            ConventionMappingHelper.map((Task)processResources, "manifestFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return variantOutputData.manifestProcessorTask.getOutputFile();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "instantRunManifestFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return variantOutputData.manifestProcessorTask.getInstantRunManifestOutputFile();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "resDir", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return scope.getVariantScope().getFinalResourcesDir();
                }
            });
            if (this.generateResourcePackage) {
                processResources.setPackageOutputFile(this.scope.getProcessResourcePackageOutputFile());
            }
            processResources.setType(config.getType());
            processResources.setDebuggable(((CoreBuildType)config.getBuildType()).isDebuggable());
            processResources.setAaptOptions(this.scope.getGlobalScope().getExtension().getAaptOptions());
            processResources.setPseudoLocalesEnabled(((CoreBuildType)config.getBuildType()).isPseudoLocalesEnabled());
            ConventionMappingHelper.map((Task)processResources, "resourceConfigs", new Callable<Collection<String>>(){

                @Override
                public Collection<String> call() throws Exception {
                    Collection resConfigs = config.getMergedFlavor().getResourceConfigurations();
                    if (resConfigs.size() == 1 && ((String)Iterators.getOnlyElement(resConfigs.iterator())).equals("auto")) {
                        if (scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getRevision().getMajor() >= 21) {
                            return variantData.discoverListOfResourceConfigsNotDensities();
                        }
                        return variantData.discoverListOfResourceConfigs();
                    }
                    return config.getMergedFlavor().getResourceConfigurations();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "preferredDensity", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String variantFilter = variantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY);
                    if (variantFilter != null) {
                        return variantFilter;
                    }
                    return AndroidGradleOptions.getBuildTargetDensity(scope.getGlobalScope().getProject());
                }
            });
            processResources.setMergeBlameLogFolder(this.scope.getVariantScope().getResourceBlameLogDir());
            processResources.instantRunBuildContext = this.scope.getVariantScope().getInstantRunBuildContext();
        }
    }
}

