/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public class JacocoTransform
extends Transform {
    private final Supplier<Collection<File>> jacocoClasspath = Suppliers.memoize(() -> configurations.getByName("androidJacocoAgent").getFiles());

    public JacocoTransform(ConfigurationContainer configurations) {
    }

    public String getName() {
        return "jacoco";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[0]);
    }

    public Collection<File> getSecondaryFileInputs() {
        return (Collection)this.jacocoClasspath.get();
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        Preconditions.checkNotNull((Object)invocation.getOutputProvider(), (Object)("Missing output object for transform " + this.getName()));
        File outputDir = invocation.getOutputProvider().getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        FileUtils.mkdirs((File)outputDir);
        TransformInput input = (TransformInput)Iterables.getOnlyElement((Iterable)invocation.getInputs());
        Preconditions.checkState((boolean)input.getJarInputs().isEmpty());
        DirectoryInput directoryInput = (DirectoryInput)Iterables.getOnlyElement((Iterable)input.getDirectoryInputs());
        File inputDir = directoryInput.getFile();
        Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        if (invocation.isIncremental()) {
            JacocoTransform.instrumentFilesIncremental(instrumenter, inputDir, outputDir, directoryInput.getChangedFiles());
        } else {
            JacocoTransform.instrumentFilesFullRun(instrumenter, inputDir, outputDir);
        }
    }

    private static void instrumentFilesIncremental(Instrumenter instrumenter, File inputDir, File outputDir, Map<File, Status> changedFiles) throws IOException {
        for (Map.Entry<File, Status> changedInput : changedFiles.entrySet()) {
            File inputFile = changedInput.getKey();
            if (!inputFile.getName().endsWith(".class")) continue;
            File outputFile = new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
            switch (changedInput.getValue()) {
                case REMOVED: {
                    FileUtils.delete((File)outputFile);
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    JacocoTransform.instrumentFile(instrumenter, inputFile, outputFile);
                }
            }
        }
    }

    private static void instrumentFilesFullRun(Instrumenter instrumenter, File inputDir, File outputDir) throws IOException {
        FileUtils.cleanOutputDir((File)outputDir);
        FluentIterable files = FileUtils.getAllFiles((File)inputDir);
        for (File inputFile : files) {
            if (!inputFile.getName().endsWith(".class")) continue;
            File outputFile = new File(outputDir, FileUtils.relativePath((File)inputFile, (File)inputDir));
            JacocoTransform.instrumentFile(instrumenter, inputFile, outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentFile(Instrumenter instrumenter, File inputFile, File outputFile) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = Files.asByteSource((File)inputFile).openBufferedStream();
            Files.createParentDirs((File)outputFile);
            byte[] instrumented = instrumenter.instrument(inputStream, inputFile.toString());
            Files.write((byte[])instrumented, (File)outputFile);
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
    }
}

