/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.ide.common.process.ProcessException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class JackJacocoReportTask
extends BaseTask {
    private File coverageDirectory;
    private File reportDir;
    private List<File> sourceDir;
    private String reportName;
    private File metadataFile;

    @InputDirectory
    public File getCoverageDirectory() {
        return this.coverageDirectory;
    }

    public void setCoverageDirectory(File coverageDirectory) {
        this.coverageDirectory = coverageDirectory;
    }

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @InputFiles
    public List<File> getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(List<File> sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Input
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @InputFile
    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile;
    }

    @TaskAction
    void createReport() throws ProcessException {
        ArrayList coverageFiles = Lists.newArrayList();
        if (this.getCoverageDirectory() != null) {
            Files.fileTreeTraverser().breadthFirstTraversal((Object)this.getCoverageDirectory()).filter(File::isFile).copyInto((Collection)coverageFiles);
        }
        if (coverageFiles.isEmpty()) {
            throw new ProcessException(String.format("No coverage data to process in directory '%1$s'", this.getCoverageDirectory()));
        }
        if (coverageFiles.size() > 1) {
            throw new ProcessException(String.format("More than one coverage file found in directory '%1$s', sharding for test coverage is not yet supported for Jack", this.getCoverageDirectory()));
        }
        this.getBuilder().createJacocoReportWithJackReporter((File)Iterables.getOnlyElement((Iterable)coverageFiles), this.getReportDir(), this.getSourceDir(), this.getReportName(), this.getMetadataFile());
    }

    public static class ConfigAction
    implements TaskConfigAction<JackJacocoReportTask> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JackJacocoReportTask> getType() {
            return JackJacocoReportTask.class;
        }

        @Override
        public void execute(JackJacocoReportTask task) {
            task.setVariantName(this.scope.getVariantConfiguration().getFullName());
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            Preconditions.checkNotNull((Object)this.scope.getTestedVariantData());
            VariantScope testedScope = this.scope.getTestedVariantData().getScope();
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(this.scope.getVariantConfiguration().getFullName());
            ConventionMappingHelper.map((Task)task, "coverageDirectory", () -> ((TestVariantData)this.scope.getVariantData()).connectedTestTask.getCoverageDir());
            ConventionMappingHelper.map((Task)task, "sourceDir", () -> testedScope.getVariantData().getJavaSourceFoldersForCoverage());
            task.setReportDir(testedScope.getCoverageReportDir());
            task.setMetadataFile(testedScope.getJackCoverageMetadataFile());
        }
    }
}

