/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class IncrementalTransformInput {
    private final Map<File, QualifiedContent> jarInputs = Maps.newHashMap();
    private final List<MutableDirectoryInput> folderInputs = Lists.newArrayList();
    private final List<JarInput> convertedJarInputs = Lists.newArrayList();

    protected IncrementalTransformInput() {
    }

    boolean checkForJar(File file, Status status) {
        if (this.jarInputs.containsKey(file)) {
            QualifiedContent jarContent = this.jarInputs.get(file);
            this.addImmutableJar(new ImmutableJarInput(jarContent, status));
            this.jarInputs.remove(file);
            return true;
        }
        return false;
    }

    boolean checkForFolder(File file, List<String> fileSegments, Status status) {
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            if (!folderInput.processForChangedFile(file, fileSegments, status)) continue;
            return true;
        }
        return false;
    }

    boolean checkRemovedFolderFile(Set<QualifiedContent.Scope> transformScopes, Set<QualifiedContent.ContentType> transformInputTypes, File file, List<String> fileSegments) {
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            if (!folderInput.processForChangedFile(file, fileSegments, Status.REMOVED)) continue;
            return true;
        }
        return this.checkRemovedFolder(transformScopes, transformInputTypes, file, fileSegments);
    }

    abstract boolean checkRemovedJarFile(Set<QualifiedContent.Scope> var1, Set<QualifiedContent.ContentType> var2, File var3, List<String> var4);

    protected abstract boolean checkRemovedFolder(Set<QualifiedContent.Scope> var1, Set<QualifiedContent.ContentType> var2, File var3, List<String> var4);

    void addJarInput(QualifiedContent jarInput) {
        this.jarInputs.put(jarInput.getFile(), jarInput);
    }

    protected void addImmutableJar(ImmutableJarInput jarInput) {
        this.convertedJarInputs.add(jarInput);
    }

    void addFolderInput(MutableDirectoryInput folderInput) {
        this.folderInputs.add(folderInput);
    }

    ImmutableTransformInput asImmutable() {
        ArrayList immutableJarInputs = Lists.newArrayListWithCapacity((int)(this.jarInputs.size() + this.convertedJarInputs.size()));
        immutableJarInputs.addAll(this.convertedJarInputs);
        for (QualifiedContent jarContent : this.jarInputs.values()) {
            immutableJarInputs.add(new ImmutableJarInput(jarContent, Status.NOTCHANGED));
        }
        ArrayList immutableDirectoryInputs = Lists.newArrayListWithCapacity((int)this.folderInputs.size());
        for (MutableDirectoryInput folderInput : this.folderInputs) {
            immutableDirectoryInputs.add(folderInput.asImmutable());
        }
        return new ImmutableTransformInput(immutableJarInputs, immutableDirectoryInputs, null);
    }
}

