/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.SyncIssueHandler;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.DependencyContainer;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;

public class VariantDependencies {
    public static final String CONFIGURATION_METADATA = "-metadata";
    public static final String CONFIGURATION_MAPPING = "-mapping";
    public static final String CONFIGURATION_CLASSES = "-classes";
    public static final String CONFIGURATION_MANIFEST = "-manifest";
    private final String variantName;
    private final Configuration compileConfiguration;
    private final Configuration packageConfiguration;
    private final Configuration publishConfiguration;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration mappingConfiguration;
    private final Configuration classesConfiguration;
    private final Configuration metadataConfiguration;
    private Configuration manifestConfiguration;
    private DependencyContainer compileDependencies;
    private DependencyContainer packageDependencies;
    private boolean annotationsPresent;
    private DependencyChecker checker;

    public static VariantDependencies compute(Project project, ErrorReporter errorReporter, String variantName, boolean publishVariant, VariantType variantType, VariantType testedVariantType, VariantDependencies parentVariant, ConfigurationProvider ... providers) {
        HashSet compileConfigs = Sets.newHashSetWithExpectedSize((int)(providers.length * 2));
        HashSet apkConfigs = Sets.newHashSetWithExpectedSize((int)providers.length);
        HashSet annotationConfigs = Sets.newHashSetWithExpectedSize((int)providers.length);
        for (ConfigurationProvider provider : providers) {
            if (provider == null) continue;
            compileConfigs.add(provider.getCompileConfiguration());
            if (provider.getProvidedConfiguration() != null) {
                compileConfigs.add(provider.getProvidedConfiguration());
            }
            apkConfigs.add(provider.getCompileConfiguration());
            apkConfigs.add(provider.getPackageConfiguration());
            annotationConfigs.add(provider.getAnnotationProcessorConfiguration());
        }
        if (parentVariant != null) {
            compileConfigs.add(parentVariant.getCompileConfiguration());
            apkConfigs.add(parentVariant.getPackageConfiguration());
            annotationConfigs.add(parentVariant.getAnnotationProcessorConfiguration());
        }
        Configuration compile = (Configuration)project.getConfigurations().maybeCreate("_" + variantName + "Compile");
        compile.setVisible(false);
        compile.setDescription("## Internal use, do not manually configure ##");
        compile.setExtendsFrom((Iterable)compileConfigs);
        Configuration annotationProcessor = (Configuration)project.getConfigurations().maybeCreate("_" + variantName + "AnnotationProcessor");
        annotationProcessor.setVisible(false);
        annotationProcessor.setDescription("## Internal use, do not manually configure ##");
        annotationProcessor.setExtendsFrom((Iterable)annotationConfigs);
        Configuration apk = (Configuration)project.getConfigurations().maybeCreate(variantType == VariantType.LIBRARY ? "_" + variantName + "Publish" : "_" + variantName + "Apk");
        apk.setVisible(false);
        apk.setDescription("## Internal use, do not manually configure ##");
        apk.setExtendsFrom((Iterable)apkConfigs);
        Configuration publish = null;
        Configuration mapping = null;
        Configuration classes = null;
        Configuration metadata = null;
        Configuration manifest = null;
        if (publishVariant) {
            publish = (Configuration)project.getConfigurations().maybeCreate(variantName);
            publish.setDescription("Published Configuration for Variant " + variantName);
            if (variantType == VariantType.LIBRARY) {
                publish.setExtendsFrom((Iterable)apkConfigs);
            }
            metadata = (Configuration)project.getConfigurations().create(variantName + CONFIGURATION_METADATA);
            metadata.setDescription("Published APKs metadata for Variant " + variantName);
            mapping = (Configuration)project.getConfigurations().maybeCreate(variantName + CONFIGURATION_MAPPING);
            mapping.setDescription("Published mapping configuration for Variant " + variantName);
            classes = (Configuration)project.getConfigurations().maybeCreate(variantName + CONFIGURATION_CLASSES);
            classes.setDescription("Published classes configuration for Variant " + variantName);
            manifest = (Configuration)project.getConfigurations().maybeCreate(variantName + CONFIGURATION_MANIFEST);
            manifest.setDescription("Published manifest configuration for Variant " + variantName);
            classes.setExtendsFrom((Iterable)compileConfigs);
        }
        DependencyChecker checker = new DependencyChecker(project.getName(), variantName, (SyncIssueHandler)errorReporter, variantType, testedVariantType);
        return new VariantDependencies(variantName, checker, compile, apk, publish, annotationProcessor, mapping, classes, metadata, manifest);
    }

    private VariantDependencies(String variantName, DependencyChecker dependencyChecker, Configuration compileConfiguration, Configuration packageConfiguration, Configuration publishConfiguration, Configuration annotationProcessorConfiguration, Configuration mappingConfiguration, Configuration classesConfiguration, Configuration metadataConfiguration, Configuration manifestConfiguration) {
        this.variantName = variantName;
        this.compileConfiguration = compileConfiguration;
        this.packageConfiguration = packageConfiguration;
        this.publishConfiguration = publishConfiguration;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.mappingConfiguration = mappingConfiguration;
        this.classesConfiguration = classesConfiguration;
        this.metadataConfiguration = metadataConfiguration;
        this.manifestConfiguration = manifestConfiguration;
        this.checker = dependencyChecker;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileConfiguration() {
        return this.compileConfiguration;
    }

    public Configuration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Configuration getPublishConfiguration() {
        return this.publishConfiguration;
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    public Configuration getClassesConfiguration() {
        return this.classesConfiguration;
    }

    public Configuration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public Configuration getManifestConfiguration() {
        return this.manifestConfiguration;
    }

    public void setDependencies(DependencyContainer compileDependencies, DependencyContainer packageDependencies) {
        this.compileDependencies = compileDependencies;
        this.packageDependencies = packageDependencies;
    }

    public DependencyContainer getCompileDependencies() {
        return this.compileDependencies;
    }

    public DependencyContainer getPackageDependencies() {
        return this.packageDependencies;
    }

    public Set<File> resolveAndGetAnnotationProcessorClassPath(boolean includeClasspath, ErrorReporter errorReporter) {
        ResolvedConfiguration resolvedConfiguration;
        if (this.getAnnotationProcessorConfiguration().getAllDependencies().isEmpty()) {
            return Collections.emptySet();
        }
        if (this.getAnnotationProcessorConfiguration().getState() != Configuration.State.RESOLVED && includeClasspath) {
            this.getAnnotationProcessorConfiguration().extendsFrom(new Configuration[]{this.getCompileConfiguration(), this.getPackageConfiguration()});
        }
        if ((resolvedConfiguration = this.getAnnotationProcessorConfiguration().getResolvedConfiguration()).hasError()) {
            try {
                resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                errorReporter.handleSyncError("annotationProcessor", 2, e.getMessage());
                return Collections.emptySet();
            }
        }
        return this.getAnnotationProcessorConfiguration().getFiles();
    }

    public DependencyChecker getChecker() {
        return this.checker;
    }

    public void setAnnotationsPresent(boolean annotationsPresent) {
        this.annotationsPresent = annotationsPresent;
    }

    public boolean isAnnotationsPresent() {
        return this.annotationsPresent;
    }

    public boolean hasNonOptionalLibraries() {
        return !this.packageDependencies.getAndroidDependencies().isEmpty();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }
}

