/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.builder.core.BuilderConstants;
import groovy.lang.Closure;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.execution.TaskGraphExecuter;

class ReportingPlugin
implements Plugin<Project> {
    private TestOptions extension;

    ReportingPlugin() {
    }

    public void apply(final Project project) {
        project.evaluationDependsOnChildren();
        this.extension = (TestOptions)project.getExtensions().create("android", TestOptions.class, new Object[0]);
        final AndroidReportTask mergeReportsTask = (AndroidReportTask)project.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        ConventionMappingHelper.map((Task)mergeReportsTask, "resultsDir", new Callable<File>(){

            @Override
            public File call() throws Exception {
                String resultsDir = ReportingPlugin.this.extension.getResultsDir();
                if (resultsDir == null) {
                    return new File(project.getBuildDir(), BuilderConstants.FD_ANDROID_RESULTS);
                }
                return project.file((Object)resultsDir);
            }
        });
        ConventionMappingHelper.map((Task)mergeReportsTask, "reportsDir", new Callable<File>(){

            @Override
            public File call() throws Exception {
                String reportsDir = ReportingPlugin.this.extension.getReportDir();
                if (reportsDir == null) {
                    return new File(new File(project.getBuildDir(), "reports"), "androidTests");
                }
                return project.file((Object)reportsDir);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project prj) {
                for (Project p : prj.getSubprojects()) {
                    TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                    for (AndroidReportTask task : tasks) {
                        mergeReportsTask.addTask(task);
                    }
                    TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                    for (DeviceProviderInstrumentTestTask task : tasks2) {
                        mergeReportsTask.addTask(task);
                    }
                }
            }
        });
        if (mergeReportsTask != null && project.getGradle().getStartParameter().isContinueOnFailure()) {
            project.getGradle().getTaskGraph().whenReady(new Closure(this){

                void doCall(TaskGraphExecuter taskGraph) {
                    if (taskGraph.hasTask((Task)mergeReportsTask)) {
                        mergeReportsTask.setWillRun();
                    }
                }
            });
        }
    }
}

