/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.builder.core.VariantType;
import com.android.builder.shrinker.JavaSerializationShrinkerGraph;
import com.android.builder.shrinker.ProguardConfigKeepRulesBuilder;
import com.android.builder.shrinker.Shrinker;
import com.android.builder.shrinker.ShrinkerGraph;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class NewShrinkerTransform
extends ProguardConfigurable {
    private static final String NAME = "newClassShrinker";
    private final VariantType variantType;
    private final File platformJar;
    private final File incrementalDir;

    public NewShrinkerTransform(VariantScope scope) {
        IAndroidTarget target = scope.getGlobalScope().getAndroidBuilder().getTarget();
        Preconditions.checkState((target != null ? 1 : 0) != 0, (Object)"SDK target not ready.");
        this.platformJar = new File(target.getPath(1));
        this.variantType = scope.getVariantData().getType();
        this.incrementalDir = scope.getIncrementalDir(scope.getTaskName(NAME));
    }

    public String getName() {
        return NAME;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        if (this.variantType == VariantType.LIBRARY) {
            return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT_LOCAL_DEPS});
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        LinkedHashSet set = Sets.newLinkedHashSetWithExpectedSize((int)5);
        if (this.variantType == VariantType.LIBRARY) {
            set.add(QualifiedContent.Scope.SUB_PROJECTS);
            set.add(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS);
            set.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        }
        if (this.variantType.isForTesting()) {
            throw new IllegalStateException("New class shrinker is not supported in test variants.");
        }
        set.add(QualifiedContent.Scope.PROVIDED_ONLY);
        return Sets.immutableEnumSet((Iterable)set);
    }

    public Collection<File> getSecondaryFileInputs() {
        return ImmutableList.builder().addAll(this.getAllConfigurationFiles()).add((Object)this.incrementalDir).build();
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        Shrinker shrinker = new Shrinker(new WaitableExecutor(), (ShrinkerGraph)new JavaSerializationShrinkerGraph(this.incrementalDir), this.platformJar);
        ProguardConfigKeepRulesBuilder parser = new ProguardConfigKeepRulesBuilder();
        for (File configFile : this.getAllConfigurationFiles()) {
            parser.parse(configFile);
        }
        shrinker.run(inputs, referencedInputs, outputProvider, ImmutableMap.of((Object)Shrinker.ShrinkType.SHRINK, (Object)parser.getKeepRules()), isIncremental);
    }
}

