/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.JarMerger;
import com.android.builder.signing.SignedJarBuilder;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class JarMergingTransform
extends Transform {
    private final ImmutableSet<QualifiedContent.Scope> scopes;

    public JarMergingTransform(Set<QualifiedContent.Scope> scopes) {
        this.scopes = ImmutableSet.copyOf(scopes);
    }

    public String getName() {
        return "jarMerging";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedStreams, TransformOutputProvider outputProvider, boolean isIncremental) throws TransformException, IOException {
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        File jarFile = outputProvider.getContentLocation("combined", this.getOutputTypes(), this.getScopes(), Format.JAR);
        FileUtils.mkdirs((File)jarFile.getParentFile());
        FileUtils.deleteIfExists((File)jarFile);
        JarMerger jarMerger = new JarMerger(jarFile);
        try {
            jarMerger.setFilter(new SignedJarBuilder.IZipEntryFilter(){

                public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
                    return archivePath.endsWith(".class");
                }
            });
            for (TransformInput input : inputs) {
                for (JarInput jarInput : input.getJarInputs()) {
                    jarMerger.addJar(jarInput.getFile());
                }
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    jarMerger.addFolder(directoryInput.getFile());
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TransformException((Throwable)e);
        }
        catch (IOException e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            jarMerger.close();
        }
    }
}

