/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;

public class AndroidGradleOptions {
    private static final String PROPERTY_TEST_RUNNER_ARGS = "android.testInstrumentationRunnerArguments.";
    private static final String PROPERTY_THREAD_POOL_SIZE = "android.threadPoolSize";
    private static final String PROPERTY_THREAD_POOL_SIZE_OLD = "com.android.build.threadPoolSize";
    private static final String PROPERTY_NEW_SHRINKER = "android.newShrinker";
    private static final String PROPERTY_DISABLE_RESOURCE_VALIDATION = "android.disableResourceValidation";
    private static final String PROPERTY_BENCHMARK_NAME = "com.android.benchmark.name";
    private static final String PROPERTY_BENCHMARK_MODE = "com.android.benchmark.mode";

    public static Map<String, String> getExtraInstrumentationTestRunnerArgs(Project project) {
        HashMap argsMap = Maps.newHashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROPERTY_TEST_RUNNER_ARGS)) continue;
            String argName = ((String)entry.getKey()).substring(PROPERTY_TEST_RUNNER_ARGS.length());
            String argValue = entry.getValue().toString();
            argsMap.put(argName, argValue);
        }
        return argsMap;
    }

    public static String getBenchmarkName(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_NAME);
    }

    public static String getBenchmarkMode(Project project) {
        return AndroidGradleOptions.getString(project, PROPERTY_BENCHMARK_MODE);
    }

    public static boolean invokedFromIde(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.invoked.from.ide");
    }

    public static boolean buildModelOnly(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only");
    }

    public static boolean buildModelOnlyAdvanced(Project project) {
        return AndroidGradleOptions.getBoolean(project, "android.injected.build.model.only.advanced");
    }

    public static String getApkLocation(Project project) {
        return AndroidGradleOptions.getString(project, "android.injected.apk.location");
    }

    public static boolean isIntegrationTest() {
        return Boolean.parseBoolean(System.getenv("INTEGRATION_TEST"));
    }

    public static Integer getThreadPoolSize(Project project) {
        Integer size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE);
        if (size == null) {
            size = AndroidGradleOptions.getInteger(project, PROPERTY_THREAD_POOL_SIZE_OLD);
        }
        return size;
    }

    public static SigningOptions getSigningOptions(Project project) {
        String signingStoreFile = AndroidGradleOptions.getString(project, "android.injected.signing.store.file");
        String signingStorePassword = AndroidGradleOptions.getString(project, "android.injected.signing.store.password");
        String signingKeyAlias = AndroidGradleOptions.getString(project, "android.injected.signing.key.alias");
        String signingKeyPassword = AndroidGradleOptions.getString(project, "android.injected.signing.key.password");
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            String signingStoreType = AndroidGradleOptions.getString(project, "android.injected.signing.store.type");
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, signingStoreType);
        }
        return null;
    }

    public static boolean useNewShrinker(Project project) {
        return AndroidGradleOptions.getBoolean(project, PROPERTY_NEW_SHRINKER);
    }

    public static boolean isResourceValidationEnabled(Project project) {
        return !AndroidGradleOptions.getBoolean(project, PROPERTY_DISABLE_RESOURCE_VALIDATION);
    }

    private static String getString(Project project, String propertyName) {
        return (String)project.getProperties().get(propertyName);
    }

    private static Integer getInteger(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            try {
                return Integer.parseInt(project.getProperties().get(propertyName).toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Property " + propertyName + " needs to be an integer.");
            }
        }
        return null;
    }

    private static boolean getBoolean(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            Object value = project.getProperties().get(propertyName);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return false;
    }

    public static class SigningOptions {
        public final String storeFile;
        public final String storePassword;
        public final String keyAlias;
        public final String keyPassword;
        public final String storeType;

        public SigningOptions(String storeFile, String storePassword, String keyAlias, String keyPassword, String storeType) {
            this.storeFile = storeFile;
            this.storeType = storeType;
            this.storePassword = storePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
        }
    }
}

