/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;

public class LruDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        DaemonRegistry registry = daemon.getDaemonRegistry();
        return registry.getAll().size() > 1 && this.isOldest(daemon.getDaemonContext(), registry) ? new DaemonExpirationResult(true, "This is the least recently used daemon") : new DaemonExpirationResult(false, null);
    }

    @VisibleForTesting
    boolean isOldest(DaemonContext thisDaemon, DaemonRegistry registry) {
        long oldestPid = -1L;
        Date oldestTimestamp = new Date(Long.MAX_VALUE);
        for (DaemonInfo daemon : registry.getIdle()) {
            Date daemonAccessTime = daemon.getLastBusy();
            if (!daemonAccessTime.before(oldestTimestamp)) continue;
            oldestPid = daemon.getPid();
            oldestTimestamp = daemonAccessTime;
        }
        return oldestPid == thisDaemon.getPid();
    }
}

