/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonIdleTimeoutExpirationStrategy
implements DaemonExpirationStrategy {
    private static final Logger LOG = Logging.getLogger(DaemonIdleTimeoutExpirationStrategy.class);
    private Function<?, Long> idleTimeout;

    public DaemonIdleTimeoutExpirationStrategy(int idleTimeout, TimeUnit timeUnit) {
        this(Functions.constant((Object)timeUnit.toMillis(idleTimeout)));
    }

    public DaemonIdleTimeoutExpirationStrategy(Function<?, Long> timeoutClosure) {
        this.idleTimeout = (Function)Preconditions.checkNotNull(timeoutClosure);
    }

    @Override
    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        boolean idleTimeoutExceeded;
        long idleMillis = daemon.getStateCoordinator().getIdleMillis(System.currentTimeMillis());
        boolean bl = idleTimeoutExceeded = idleMillis > (Long)this.idleTimeout.apply(null);
        if (idleTimeoutExceeded) {
            LOG.info("Idle timeout: daemon has been idle for {} milliseconds. Expiring.", (Object)idleMillis);
            return new DaemonExpirationResult(true, "daemon has been idle for " + idleMillis + " milliseconds");
        }
        return new DaemonExpirationResult(false, null);
    }
}

