/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.util;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ManifestUtils {
    @Nullable
    public static VirtualFile getAndroidManiFest(@NotNull Module module) {
        File file;
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null && (file = facet.getMainSourceProvider().getManifestFile()) != null) {
            return LocalFileSystem.getInstance().findFileByIoFile(file);
        }
        return null;
    }

    @Nullable
    public static XmlFile getAndroidManifestPsi(@NotNull Module module) {
        PsiFile psiFile;
        VirtualFile manifest = ManifestUtils.getAndroidManiFest(module);
        if (manifest != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(manifest)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @NotNull
    public static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, final @NotNull String tagName) {
        final ArrayList tags = Lists.newArrayList();
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (tag.getName().equalsIgnoreCase(tagName)) {
                    tags.add(tag);
                }
            }
        });
        return tags;
    }
}

