/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.Lists;
import com.google.api.services.fetchasgoogle_pa.FetchasgooglePa;
import com.google.api.services.fetchasgoogle_pa.model.Apk;
import com.google.api.services.fetchasgoogle_pa.model.ApkDataRef;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.AppIndexingApiData;
import com.google.api.services.fetchasgoogle_pa.model.FetchRequest;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.api.services.fetchasgoogle_pa.model.Intent;
import com.google.api.services.fetchasgoogle_pa.model.Operation;
import com.google.api.services.fetchasgoogle_pa.model.ReferencedResource;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchAsGoogleClient {
    private static final NetHttpTransport httpTransport = new NetHttpTransport();
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final String SERVER_PATH = "";
    private static final String ROOT_URL = "https://fetchasgoogle-pa.googleapis.com";
    private static final String MIME_TYPE = "application/vnd.android.package-archive";
    private static final int CHUNK_SIZE = 1024;
    private static final int KB = 1024;
    private static final String UPLOAD_SOURCE = "ANDROID_STUDIO";
    private static final String URL_TYPE_KEY = "@type";
    private static final String URL_TYPE = "type.googleapis.com/google.internal.fetchasgoogle.v1.FetchResponse";
    private static final String STATUS_KEY = "status";
    private static final String APP_INDEXING_API_DATA_KEY = "appIndexingApiData";
    private static final String APP_URI_KEY = "appUri";
    private static final String WEB_URL_KEY = "webUrl";
    private static final String TITLE_KEY = "title";
    private static final String DESCRIPTION_KEY = "description";
    private static final String SCREENSHOT_DATA_KEY = "screenshotData";
    private static final String REFERENCED_RESOURCE_KEY = "referencedResource";
    private static final String REQUEST_KEY = "request";
    private static final String RESPONSE_KEY = "response";
    private static final String FETCH_STATUS_KEY = "fetchStatus";
    private static final String GENERIC_ERROR_INFO_KEY = "genericErrorInfo";
    private static final String OK_STATUS = "OK";
    private static final String INTENT_URI_NOT_SUPPORTED_REASON = "INTENT_URI_NOT_SUPPORTED";
    private static final int FETCH_TIME_INTERVAL_IN_MS = 5000;
    @NotNull
    private FetchasgooglePa myStub;

    @NotNull
    public static FetchAsGoogleClient createInstance() throws FetchAsGoogleException {
        FetchasgooglePa stub = FetchAsGoogleClient.createStub();
        if (stub == null) {
            throw new FetchAsGoogleException("Could not find user credentials", FetchAsGoogleException.ErrorCode.NO_CREDENTIAL);
        }
        return new FetchAsGoogleClient(stub);
    }

    private FetchAsGoogleClient(@NotNull FetchasgooglePa stub) {
        this.myStub = stub;
    }

    @Nullable
    private static FetchasgooglePa createStub() {
        CredentialedUser user = GoogleLogin.getInstance().getActiveUser();
        if (user != null) {
            return new FetchasgooglePa.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)new FetchAsGoogleHttpRequestInitializer(user.getCredential())).setServicePath(SERVER_PATH).setRootUrl(ROOT_URL).build();
        }
        return null;
    }

    @NotNull
    public ApkHolder uploadApk(@NotNull String packageId, @NotNull File apkFile) throws FetchAsGoogleException, IOException {
        ApkDataRef apkDataRef = (ApkDataRef)this.myStub.apks().startUpload().execute();
        FetchasgooglePa.Media.Upload upload = this.myStub.media().upload(apkDataRef.getResourceName(), null, (AbstractInputStreamContent)new FileContent(MIME_TYPE, apkFile));
        upload.getMediaHttpUploader().setDirectUploadEnabled(true);
        upload.getMediaHttpUploader().setChunkSize(0x100000);
        HttpResponse response = upload.executeUnparsed();
        if (response.getStatusCode() != 200) {
            throw new FetchAsGoogleException("Failed to upload Apk: " + response, FetchAsGoogleException.ErrorCode.UPLOAD_ERROR);
        }
        Apk feagApk = new Apk().setPackageId(packageId).setSource(UPLOAD_SOURCE);
        ApkHolder apk = new ApkHolder().setApk(feagApk).setApkDataRef(apkDataRef);
        return (ApkHolder)this.myStub.apks().create(apk).execute();
    }

    @NotNull
    public FetchResponse fetchAsGoogle(@NotNull String deepLink, @NotNull ApkHolder apkHolder, @NotNull String language) throws FetchAsGoogleException, IOException, InterruptedException {
        Operation startFetchResult = this.startFetch(deepLink, apkHolder, language);
        if (startFetchResult == null) {
            throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.FETCH_ERROR);
        }
        Operation result = null;
        String fetchToken = startFetchResult.getName();
        if (fetchToken == null || fetchToken.isEmpty()) {
            throw new FetchAsGoogleException("No fetch token returned", FetchAsGoogleException.ErrorCode.FETCH_ERROR);
        }
        do {
            Thread.sleep(5000L);
            result = this.getFetchResult(fetchToken);
            if (result == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.FETCH_ERROR);
            }
            if (result.getDone() == null || !result.getDone().booleanValue()) continue;
            if (result.getError() != null) {
                throw new FetchAsGoogleException("Operation failed with error status: " + result.getError(), FetchAsGoogleException.ErrorCode.FETCH_ERROR);
            }
            if (result.getResponse() == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.FETCH_ERROR);
            }
            if (!result.getResponse().get(URL_TYPE_KEY).equals(URL_TYPE)) {
                throw new FetchAsGoogleException("Operation response contains unexpected type: " + result.getResponse().get(URL_TYPE_KEY), FetchAsGoogleException.ErrorCode.FETCH_ERROR);
            }
            if (result.getResponse().get(STATUS_KEY) == null) {
                throw new FetchAsGoogleException("Operation failed with an empty status", FetchAsGoogleException.ErrorCode.FETCH_ERROR);
            }
            if (result.getResponse().get(STATUS_KEY).equals(OK_STATUS)) continue;
            if (INTENT_URI_NOT_SUPPORTED_REASON.equals(result.getResponse().get(GENERIC_ERROR_INFO_KEY))) {
                throw new FetchAsGoogleException("Intent url not supported", FetchAsGoogleException.ErrorCode.INTENT_URL_NOT_SUPPORTED);
            }
            throw new FetchAsGoogleException("Operation failed with error status: " + result.getResponse().get(STATUS_KEY), FetchAsGoogleException.ErrorCode.FETCH_ERROR);
        } while (result.getDone() == null || !result.getDone().booleanValue());
        return FetchAsGoogleClient.constructFetchResponse(result.getResponse());
    }

    @NotNull
    private static FetchResponse constructFetchResponse(Map<String, Object> map) {
        List referencedResource;
        FetchResponse response = new FetchResponse();
        response.setStatus((String)map.get(STATUS_KEY));
        if (map.get(SCREENSHOT_DATA_KEY) != null) {
            response.setScreenshotData((String)map.get(SCREENSHOT_DATA_KEY));
        }
        if (map.get(APP_INDEXING_API_DATA_KEY) != null) {
            AppIndexingApiData data = new AppIndexingApiData();
            Map dataMap = (Map)map.get(APP_INDEXING_API_DATA_KEY);
            data.setAppUri((String)dataMap.get(APP_URI_KEY));
            data.setWebUrl((String)dataMap.get(WEB_URL_KEY));
            data.setTitle((String)dataMap.get(TITLE_KEY));
            data.setDescription((String)dataMap.get(DESCRIPTION_KEY));
            response.setAppIndexingApiData(data);
        }
        if ((referencedResource = (List)map.get(REFERENCED_RESOURCE_KEY)) != null) {
            ArrayList resources = Lists.newArrayList();
            for (Map resource : referencedResource) {
                resources.add(new ReferencedResource().setFetchStatus((String)resource.get(FETCH_STATUS_KEY)).setRequest((String)resource.get(REQUEST_KEY)).setResponse((String)resource.get(RESPONSE_KEY)));
            }
            response.setReferencedResource((List)resources);
        }
        return response;
    }

    private Operation startFetch(String deepLink, ApkHolder apkHolder, String language) throws IOException {
        FetchRequest request = new FetchRequest().setPackageId(apkHolder.getApk().getPackageId()).setApkId(apkHolder.getApk().getApkId()).setIntent(new Intent().setUri(deepLink)).setSource(UPLOAD_SOURCE).setLanguage(language);
        FetchasgooglePa.Apks.Fetch fetch = this.myStub.apks().fetch(request);
        return (Operation)fetch.execute();
    }

    private Operation getFetchResult(String fetchToken) throws IOException {
        FetchasgooglePa.Operations.Get get = this.myStub.operations().get(fetchToken);
        return (Operation)get.execute();
    }

    private static class FetchAsGoogleHttpRequestInitializer
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        private final Credential access;

        public FetchAsGoogleHttpRequestInitializer(Credential access) {
            this.access = access;
        }

        public void initialize(HttpRequest request) throws IOException {
            this.access.initialize(request);
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) throws IOException {
            this.access.intercept(request);
        }
    }

    public static class FetchAsGoogleException
    extends Exception {
        @NotNull
        ErrorCode myErrorCode;

        public FetchAsGoogleException(String message, @NotNull ErrorCode code) {
            super(message);
            this.myErrorCode = code;
        }

        @NotNull
        public ErrorCode getErrorCode() {
            return this.myErrorCode;
        }

        public static enum ErrorCode {
            NO_CREDENTIAL,
            UPLOAD_ERROR,
            FETCH_ERROR,
            INTENT_URL_NOT_SUPPORTED;

        }
    }
}

