/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.PathToFileResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BackingFileExtractor {
    private static final Logger LOG = Logging.getLogger(BackingFileExtractor.class);

    BackingFileExtractor() {
    }

    public List<FileEntry> extractFilesOrDirectories(FileCollection fileCollection) {
        CustomFileCollectionResolveContext context = new CustomFileCollectionResolveContext();
        context.add(fileCollection);
        List<FileCollectionInternal> fileCollections = context.resolveAsFileCollections();
        ArrayList<FileEntry> results = new ArrayList<FileEntry>();
        for (FileCollectionInternal files : fileCollections) {
            this.collectBackingFiles(files, results);
        }
        return results;
    }

    private void collectBackingFiles(FileCollectionInternal fileCollection, List<FileEntry> results) {
        if (fileCollection instanceof FileTreeAdapter) {
            this.collectBackingFilesInMinimalFileTree(((FileTreeAdapter)fileCollection).getTree(), results);
        } else {
            FileSystemSubset.Builder watchPointsBuilder = FileSystemSubset.builder();
            fileCollection.registerWatchPoints(watchPointsBuilder);
            for (File file : watchPointsBuilder.build().getRoots()) {
                results.add(new FileEntry(file));
            }
        }
    }

    private void collectBackingFilesInMinimalFileTree(MinimalFileTree fileTree, final List<FileEntry> results) {
        if (fileTree instanceof DirectoryTree) {
            DirectoryTree directoryTree = (DirectoryTree)((Object)fileTree);
            results.add(new FileEntry(directoryTree.getDir(), directoryTree.getPatterns()));
        } else {
            fileTree.visitTreeOrBackingFile(new FileVisitor(){

                public void visitDir(FileVisitDetails dirDetails) {
                    results.add(new FileEntry(dirDetails.getFile()));
                }

                public void visitFile(FileVisitDetails fileDetails) {
                    results.add(new FileEntry(fileDetails.getFile()));
                }
            });
        }
    }

    private static boolean shouldIgnoreWhenExtractingBackingFiles(Object element) {
        if (element instanceof Configuration) {
            return true;
        }
        return element instanceof LazilyInitializedFileCollection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomFileCollectionConverter
    extends DefaultFileCollectionResolveContext.FileCollectionConverter {
        private CustomFileCollectionConverter() {
        }

        @Override
        public void convertInto(Object element, Collection<? super FileCollectionInternal> result, PathToFileResolver fileResolver) {
            if (BackingFileExtractor.shouldIgnoreWhenExtractingBackingFiles(element)) {
                return;
            }
            super.convertInto(element, result, fileResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomFileCollectionResolveContext
    extends DefaultFileCollectionResolveContext {
        public CustomFileCollectionResolveContext() {
            this(new IdentityFileResolver());
        }

        CustomFileCollectionResolveContext(FileResolver fileResolver) {
            this(fileResolver, new CustomFileCollectionConverter(), new DefaultFileCollectionResolveContext.FileTreeConverter(fileResolver.getPatternSetFactory()));
        }

        CustomFileCollectionResolveContext(PathToFileResolver fileResolver, DefaultFileCollectionResolveContext.Converter<? extends FileCollectionInternal> fileCollectionConverter, DefaultFileCollectionResolveContext.Converter<? extends FileTreeInternal> fileTreeConverter) {
            super(fileResolver, fileCollectionConverter, fileTreeConverter);
        }

        @Override
        protected <T> void resolveNested(FileCollectionContainer fileCollection, List<T> result, DefaultFileCollectionResolveContext.Converter<? extends T> converter) {
            if (fileCollection instanceof LazilyInitializedFileCollection) {
                converter.convertInto(fileCollection, result, this.fileResolver);
            } else {
                super.resolveNested(fileCollection, result, converter);
            }
        }

        @Override
        protected ResolvableFileCollectionResolveContext newContext(PathToFileResolver fileResolver) {
            return new CustomFileCollectionResolveContext(fileResolver, this.fileCollectionConverter, this.fileTreeConverter);
        }
    }

    public static class FileEntry {
        private final File file;
        private final PatternSet patterns;

        public FileEntry(File file) {
            this.file = file;
            this.patterns = null;
        }

        public FileEntry(File dir, PatternSet patterns) {
            this.file = dir;
            this.patterns = patterns;
        }

        public File getFile() {
            return this.file;
        }

        public PatternSet getPatterns() {
            return this.patterns;
        }
    }
}

