/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.SplitRelatedTask;
import com.android.builder.sdk.TargetInfo;
import com.android.sdklib.BuildToolInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;

@ParallelizableTask
public class SplitZipAlign
extends SplitRelatedTask {
    private List<File> densityOrLanguageInputFiles = new ArrayList<File>();
    private List<File> abiInputFiles = new ArrayList<File>();
    private String outputBaseName;
    private Set<String> densityFilters;
    private Set<String> abiFilters;
    private Set<String> languageFilters;
    private File outputDirectory;
    private File zipAlignExe;
    private boolean useOldPackaging;
    private File apkMetadataFile;

    @InputFiles
    public List<File> getDensityOrLanguageInputFiles() {
        return this.densityOrLanguageInputFiles;
    }

    @InputFiles
    public List<File> getAbiInputFiles() {
        return this.abiInputFiles;
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Input
    public Set<String> getDensityFilters() {
        return this.densityFilters;
    }

    public void setDensityFilters(Set<String> densityFilters) {
        this.densityFilters = densityFilters;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters;
    }

    @Input
    public Set<String> getLanguageFilters() {
        return this.languageFilters;
    }

    public void setLanguageFilters(Set<String> languageFilters) {
        this.languageFilters = languageFilters;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @InputFile
    public File getZipAlignExe() {
        return this.zipAlignExe;
    }

    public void setZipAlignExe(File zipAlignExe) {
        this.zipAlignExe = zipAlignExe;
    }

    @Override
    @OutputFile
    public File getApkMetadataFile() {
        return this.apkMetadataFile;
    }

    public void setApkMetadataFile(File apkMetadataFile) {
        this.apkMetadataFile = apkMetadataFile;
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ApkOutputFile outputFile : this.getOutputSplitFiles()) {
            builder.add((Object)outputFile.getOutputFile());
        }
        return builder.build();
    }

    public List<File> getInputFiles() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.getDensityOrLanguageInputFiles(), this.getAbiInputFiles()));
    }

    public synchronized ImmutableList<ApkOutputFile> getOutputSplitFiles() {
        final String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        final ImmutableList.Builder outputFiles = ImmutableList.builder();
        InputProcessor addingLogic = new InputProcessor(){

            @Override
            public void process(String split, File file) {
                outputFiles.add((Object)new ApkOutputFile(OutputFile.OutputType.SPLIT, (Collection<FilterData>)ImmutableList.of((Object)FilterDataImpl.build(SplitZipAlign.this.getFilterType(split).toString(), SplitZipAlign.this.getFilter(split))), Callables.returning((Object)new File(SplitZipAlign.this.outputDirectory, archivesBaseName + "-" + SplitZipAlign.this.outputBaseName + "_" + split + ".apk"))));
            }
        };
        this.forEachUnalignedInput(addingLogic);
        this.forEachUnsignedInput(addingLogic);
        return outputFiles.build();
    }

    public OutputFile.FilterType getFilterType(String filter) {
        String languageName = PackageSplitRes.unMangleSplitName(filter);
        if (this.languageFilters.contains(languageName)) {
            return OutputFile.FilterType.LANGUAGE;
        }
        if (this.abiFilters.contains(filter)) {
            return OutputFile.FilterType.ABI;
        }
        return OutputFile.FilterType.DENSITY;
    }

    public String getFilter(String filterWithPossibleSuffix) {
        OutputFile.FilterType type = this.getFilterType(filterWithPossibleSuffix);
        if (type == OutputFile.FilterType.DENSITY) {
            for (String density : this.densityFilters) {
                if (!filterWithPossibleSuffix.startsWith(density)) continue;
                return density;
            }
        }
        if (type == OutputFile.FilterType.LANGUAGE) {
            return PackageSplitRes.unMangleSplitName(filterWithPossibleSuffix);
        }
        return filterWithPossibleSuffix;
    }

    public boolean isFilter(String potentialFilterWithSuffix) {
        for (String density : this.densityFilters) {
            if (!potentialFilterWithSuffix.startsWith(density)) continue;
            return true;
        }
        return this.abiFilters.contains(potentialFilterWithSuffix) || this.languageFilters.contains(PackageSplitRes.unMangleSplitName(potentialFilterWithSuffix));
    }

    private void forEachUnalignedInput(InputProcessor processor) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        Pattern unalignedPattern = Pattern.compile(archivesBaseName + "-" + this.outputBaseName + "_(.*)-unaligned.apk");
        for (File file : this.getInputFiles()) {
            Matcher unaligned = unalignedPattern.matcher(file.getName());
            if (!unaligned.matches() || !this.isFilter(unaligned.group(1))) continue;
            processor.process(unaligned.group(1), file);
        }
    }

    private void forEachUnsignedInput(InputProcessor processor) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        Pattern unsignedPattern = Pattern.compile(archivesBaseName + "-" + this.outputBaseName + "_(.*)-unsigned.apk");
        for (File file : this.getInputFiles()) {
            Matcher unsigned = unsignedPattern.matcher(file.getName());
            if (!unsigned.matches() || !this.isFilter(unsigned.group(1))) continue;
            processor.process(unsigned.group(1), file);
        }
    }

    @TaskAction
    public void splitZipAlign() throws IOException {
        final String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        InputProcessor zipAlignIt = new InputProcessor(){

            @Override
            public void process(String split, final File file) {
                final File out = new File(SplitZipAlign.this.getOutputDirectory(), archivesBaseName + "-" + SplitZipAlign.this.outputBaseName + "_" + split + ".apk");
                SplitZipAlign.this.getProject().exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        execSpec.setExecutable((Object)SplitZipAlign.this.getZipAlignExe());
                        execSpec.args(new Object[]{"-f", "4"});
                        execSpec.args(new Object[]{file.getAbsolutePath()});
                        execSpec.args(new Object[]{out});
                    }
                });
            }
        };
        this.forEachUnalignedInput(zipAlignIt);
        this.forEachUnsignedInput(zipAlignIt);
        this.saveApkMetadataFile();
    }

    @Override
    public List<FilterData> getSplitsData() {
        ImmutableList.Builder filterDataBuilder = ImmutableList.builder();
        SplitRelatedTask.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.densityFilters, OutputFile.FilterType.DENSITY);
        SplitRelatedTask.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.languageFilters, OutputFile.FilterType.LANGUAGE);
        SplitRelatedTask.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.abiFilters, OutputFile.FilterType.ABI);
        return filterDataBuilder.build();
    }

    public static class ConfigAction
    implements TaskConfigAction<SplitZipAlign> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("zipAlign", "SplitPackages");
        }

        @Override
        public Class<SplitZipAlign> getType() {
            return SplitZipAlign.class;
        }

        @Override
        public void execute(SplitZipAlign zipAlign) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            List<? extends BaseVariantOutputData> outputs = variantData.getOutputs();
            final BaseVariantOutputData variantOutputData = outputs.get(0);
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            Set<String> densityFilters = variantData.getFilters(OutputFile.FilterType.DENSITY);
            Set<String> abiFilters = variantData.getFilters(OutputFile.FilterType.ABI);
            Set<String> languageFilters = variantData.getFilters(OutputFile.FilterType.LANGUAGE);
            zipAlign.setVariantName(config.getFullName());
            ConventionMappingHelper.map((Task)zipAlign, "zipAlignExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    TargetInfo info = scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                    if (info == null) {
                        return null;
                    }
                    String path = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                    if (path == null) {
                        return null;
                    }
                    return new File(path);
                }
            });
            zipAlign.setOutputDirectory(new File(this.scope.getGlobalScope().getBuildDir(), "outputs/apk"));
            ConventionMappingHelper.map((Task)zipAlign, "densityOrLanguageInputFiles", new Callable<List<File>>(){

                @Override
                public List<File> call() {
                    return variantOutputData.packageSplitResourcesTask.getOutputFiles();
                }
            });
            zipAlign.setOutputBaseName(config.getBaseName());
            zipAlign.setAbiFilters(abiFilters);
            zipAlign.setLanguageFilters(languageFilters);
            zipAlign.setDensityFilters(densityFilters);
            File metadataDirectory = new File(zipAlign.getOutputDirectory().getParentFile(), "metadata");
            zipAlign.setApkMetadataFile(new File(metadataDirectory, config.getFullName() + ".mtd"));
            ((ApkVariantOutputData)variantOutputData).splitZipAlign = zipAlign;
            zipAlign.useOldPackaging = AndroidGradleOptions.useOldPackaging(this.scope.getGlobalScope().getProject());
        }
    }

    private static interface InputProcessor {
        public void process(String var1, File var2);
    }
}

