/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import java.io.IOException;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class PreColdSwapTask
extends DefaultAndroidTask {
    private static final Logger LOG = Logging.getLogger(PreColdSwapTask.class);
    private TransformVariantScope transformVariantScope;
    private InstantRunVariantScope instantRunVariantScope;
    private InstantRunBuildContext instantRunContext;

    @TaskAction
    public void disableBuildTasksAsNeeded() throws IOException {
        LOG.info("PreColdSwapTask : build mode is %1$s", (Object)this.instantRunContext.getBuildMode().toString());
        switch (this.instantRunContext.getBuildMode()) {
            case HOT_WARM: {
                this.instantRunVariantScope.getColdSwapBuildTasks().forEach(this::disableTask);
                this.disableTask(this.instantRunVariantScope.getPackageApplicationTask());
                break;
            }
            case COLD: {
                if (this.instantRunContext.getPatchingPolicy() != InstantRunPatchingPolicy.MULTI_DEX) break;
                this.disableTask(this.instantRunVariantScope.getPackageApplicationTask());
                break;
            }
            case FULL: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown " + InstantRunBuildMode.class.getName()));
            }
        }
    }

    private <T extends Task> void disableTask(AndroidTask<T> task) {
        LOG.info("Disabling task %1$s", (Object)task.getName());
        this.transformVariantScope.getGlobalScope().getProject().getTasks().getByName(task.getName()).setEnabled(false);
    }

    public static class ConfigAction
    implements TaskConfigAction<PreColdSwapTask> {
        protected final TransformVariantScope transformVariantScope;
        protected final InstantRunVariantScope instantRunVariantScope;
        protected final String name;

        public ConfigAction(String name, TransformVariantScope transformVariantScope, InstantRunVariantScope instantRunVariantScope) {
            this.name = name;
            this.transformVariantScope = transformVariantScope;
            this.instantRunVariantScope = instantRunVariantScope;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName(this.name);
        }

        @Override
        public Class<PreColdSwapTask> getType() {
            return PreColdSwapTask.class;
        }

        @Override
        public void execute(PreColdSwapTask task) {
            task.setVariantName(this.instantRunVariantScope.getFullVariantName());
            task.transformVariantScope = this.transformVariantScope;
            task.instantRunVariantScope = this.instantRunVariantScope;
            task.instantRunContext = this.instantRunVariantScope.getInstantRunBuildContext();
        }
    }
}

