/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.tasks.GroovyGradleDetector;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

@ParallelizableTask
public class Lint
extends BaseTask {
    public static final String MODEL_LIBRARIES_PROPERTY = "lint.new-lib-model";
    public static final boolean MODEL_LIBRARIES = Boolean.getBoolean("lint.new-lib-model");
    private static final Logger LOG = Logging.getLogger(Lint.class);
    private LintOptions mLintOptions;
    private File mSdkHome;
    private boolean mFatalOnly;
    private ToolingModelBuilderRegistry mToolingRegistry;

    public void setLintOptions(LintOptions lintOptions) {
        this.mLintOptions = lintOptions;
    }

    public void setSdkHome(File sdkHome) {
        this.mSdkHome = sdkHome;
    }

    public void setToolingRegistry(ToolingModelBuilderRegistry toolingRegistry) {
        this.mToolingRegistry = toolingRegistry;
    }

    public void setFatalOnly(boolean fatalOnly) {
        this.mFatalOnly = fatalOnly;
    }

    @TaskAction
    public void lint() throws IOException {
        AndroidProject modelProject = this.createAndroidProject(this.getProject());
        if (this.getVariantName() != null && !this.getVariantName().isEmpty()) {
            for (Variant variant : modelProject.getVariants()) {
                if (!variant.getName().equals(this.getVariantName())) continue;
                this.lintSingleVariant(modelProject, variant);
            }
        } else {
            this.lintAllVariants(modelProject);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void lintAllVariants(AndroidProject modelProject) throws IOException {
        void var5_10;
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        HashMap warningMap = Maps.newHashMap();
        for (Object variant : modelProject.getVariants()) {
            List<Warning> list = this.runLint(modelProject, (Variant)variant, false);
            warningMap.put(variant, list);
        }
        boolean quiet = false;
        if (this.mLintOptions != null) {
            quiet = this.mLintOptions.isQuiet();
        }
        for (Map.Entry entry : warningMap.entrySet()) {
            Variant variant = (Variant)entry.getKey();
            List warnings = (List)entry.getValue();
            if (this.mFatalOnly || quiet) continue;
            LOG.warn("Ran lint on variant {}: {} issues found", (Object)variant.getName(), (Object)warnings.size());
        }
        List<Warning> mergedWarnings = LintGradleClient.merge(warningMap, modelProject);
        boolean bl = false;
        int warningCount = 0;
        for (Warning warning : mergedWarnings) {
            if (warning.severity == Severity.ERROR || warning.severity == Severity.FATAL) {
                ++var5_10;
                continue;
            }
            if (warning.severity != Severity.WARNING) continue;
            ++warningCount;
        }
        if (!modelProject.getVariants().isEmpty()) {
            TreeSet allVariants = Sets.newTreeSet((v1, v2) -> v1.getName().compareTo(v2.getName()));
            allVariants.addAll(modelProject.getVariants());
            Variant variant = (Variant)allVariants.iterator().next();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.mSdkHome, variant, this.getBuildTools());
            Lint.syncOptions(this.mLintOptions, client, flags, variant, this.getProject(), true, this.mFatalOnly);
            for (Reporter reporter : flags.getReporters()) {
                reporter.write((int)var5_10, warningCount, mergedWarnings);
            }
            if (flags.isSetExitCode() && var5_10 > 0) {
                this.abort();
            }
        }
    }

    private void abort() {
        String message = this.mFatalOnly ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...";
        throw new GradleException(message);
    }

    public void lintSingleVariant(AndroidProject modelProject, Variant variant) {
        this.runLint(modelProject, variant, true);
    }

    private List<Warning> runLint(AndroidProject modelProject, Variant variant, boolean report) {
        List<Warning> warnings;
        BuiltinIssueRegistry registry = Lint.createIssueRegistry();
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.mSdkHome, variant, this.getBuildTools());
        if (this.mFatalOnly) {
            if (this.mLintOptions != null && !this.mLintOptions.isCheckReleaseBuilds()) {
                return Collections.emptyList();
            }
            flags.setFatalOnly(true);
        }
        if (this.mLintOptions != null) {
            Lint.syncOptions(this.mLintOptions, client, flags, variant, this.getProject(), report, this.mFatalOnly);
        }
        if (!report || this.mFatalOnly) {
            flags.setQuiet(true);
        }
        try {
            warnings = client.run((IssueRegistry)registry);
        }
        catch (IOException e) {
            throw new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (report && client.haveErrors() && flags.isSetExitCode()) {
            this.abort();
        }
        return warnings;
    }

    private static void syncOptions(LintOptions options, LintGradleClient client, LintCliFlags flags, Variant variant, Project project, boolean report, boolean fatalOnly) {
        options.syncTo(client, flags, variant.getName(), project, report);
        if (fatalOnly || flags.isQuiet()) {
            for (Reporter reporter : flags.getReporters()) {
                reporter.setDisplayEmpty(false);
            }
        }
    }

    private AndroidProject createAndroidProject(Project gradleProject) {
        String modelName = AndroidProject.class.getName();
        ToolingModelBuilder modelBuilder = this.mToolingRegistry.getBuilder(modelName);
        assert (modelBuilder != null);
        return (AndroidProject)modelBuilder.buildAll(modelName, gradleProject);
    }

    private static BuiltinIssueRegistry createIssueRegistry() {
        return new LintGradleIssueRegistry();
    }

    public static class GlobalConfigAction
    implements TaskConfigAction<Lint> {
        private final GlobalScope globalScope;

        public GlobalConfigAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "lint";
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint lintTask) {
            lintTask.setDescription("Runs lint on all variants.");
            lintTask.setVariantName("");
            lintTask.setGroup("verification");
            lintTask.setLintOptions(this.globalScope.getExtension().getLintOptions());
            File sdkFolder = this.globalScope.getSdkHandler().getSdkFolder();
            if (sdkFolder != null) {
                lintTask.setSdkHome(sdkFolder);
            }
            lintTask.setToolingRegistry(this.globalScope.getToolingRegistry());
            lintTask.setAndroidBuilder(this.globalScope.getAndroidBuilder());
        }
    }

    public static class VitalConfigAction
    implements TaskConfigAction<Lint> {
        private final VariantScope scope;

        public VitalConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lintVital");
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint task) {
            String variantName = this.scope.getVariantData().getVariantConfiguration().getFullName();
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setLintOptions(this.scope.getGlobalScope().getExtension().getLintOptions());
            task.setSdkHome((File)Preconditions.checkNotNull((Object)this.scope.getGlobalScope().getSdkHandler().getSdkFolder(), (Object)"SDK not set up."));
            task.setVariantName(variantName);
            task.setToolingRegistry(this.scope.getGlobalScope().getToolingRegistry());
            task.setFatalOnly(true);
            task.setDescription("Runs lint on just the fatal issues in the " + variantName + " build.");
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<Lint> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lint");
        }

        @Override
        public Class<Lint> getType() {
            return Lint.class;
        }

        @Override
        public void execute(Lint lint) {
            lint.setLintOptions(this.scope.getGlobalScope().getExtension().getLintOptions());
            File sdkFolder = this.scope.getGlobalScope().getSdkHandler().getSdkFolder();
            if (sdkFolder != null) {
                lint.setSdkHome(sdkFolder);
            }
            lint.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            lint.setVariantName(this.scope.getVariantConfiguration().getFullName());
            lint.setToolingRegistry(this.scope.getGlobalScope().getToolingRegistry());
            lint.setDescription("Runs lint on the " + StringHelper.capitalize((String)this.scope.getVariantConfiguration().getFullName()) + " build.");
            lint.setGroup("verification");
        }
    }

    public static class LintGradleIssueRegistry
    extends BuiltinIssueRegistry {
        private boolean mInitialized;

        public List<Issue> getIssues() {
            List issues = super.getIssues();
            if (!this.mInitialized) {
                this.mInitialized = true;
                for (Issue issue : issues) {
                    if (issue.getImplementation().getDetectorClass() != GradleDetector.class) continue;
                    issue.setImplementation(GroovyGradleDetector.IMPLEMENTATION);
                }
            }
            return issues;
        }
    }
}

