/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.compiling.BuildConfigGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateBuildConfig
extends BaseTask {
    private File sourceOutputDir;
    private String buildConfigPackageName;
    private String appPackageName;
    private boolean debuggable;
    private String flavorName;
    private List<String> flavorNamesWithDimensionNames;
    private String buildTypeName;
    private String versionName;
    private int versionCode;
    private List<Object> items;

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @Input
    public String getBuildConfigPackageName() {
        return this.buildConfigPackageName;
    }

    public void setBuildConfigPackageName(String buildConfigPackageName) {
        this.buildConfigPackageName = buildConfigPackageName;
    }

    @Input
    public String getAppPackageName() {
        return this.appPackageName;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName) {
        this.flavorName = flavorName;
    }

    @Input
    public List<String> getFlavorNamesWithDimensionNames() {
        return this.flavorNamesWithDimensionNames;
    }

    public void setFlavorNamesWithDimensionNames(List<String> flavorNamesWithDimensionNames) {
        this.flavorNamesWithDimensionNames = flavorNamesWithDimensionNames;
    }

    @Input
    public String getBuildTypeName() {
        return this.buildTypeName;
    }

    public void setBuildTypeName(String buildTypeName) {
        this.buildTypeName = buildTypeName;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    @Input
    public int getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    @Input
    List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object object : resolvedItems) {
            if (object instanceof String) {
                list.add((String)object);
                continue;
            }
            if (!(object instanceof ClassField)) continue;
            ClassField field = (ClassField)object;
            list.add(field.getType());
            list.add(field.getName());
            list.add(field.getValue());
        }
        return list;
    }

    @TaskAction
    void generate() throws IOException {
        File destinationDir = this.getSourceOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        BuildConfigGenerator generator = new BuildConfigGenerator(this.getSourceOutputDir(), this.getBuildConfigPackageName());
        generator.addField("boolean", "DEBUG", this.isDebuggable() ? "Boolean.parseBoolean(\"true\")" : "false").addField("String", "APPLICATION_ID", '\"' + this.getAppPackageName() + '\"').addField("String", "BUILD_TYPE", '\"' + this.getBuildTypeName() + '\"').addField("String", "FLAVOR", '\"' + this.getFlavorName() + '\"').addField("int", "VERSION_CODE", Integer.toString(this.getVersionCode())).addField("String", "VERSION_NAME", '\"' + Strings.nullToEmpty((String)this.getVersionName()) + '\"').addItems(this.getItems());
        List<String> flavors = this.getFlavorNamesWithDimensionNames();
        int count = flavors.size();
        if (count > 1) {
            for (int i = 0; i < count; i += 2) {
                generator.addField("String", "FLAVOR_" + flavors.get(i + 1), '\"' + flavors.get(i) + '\"');
            }
        }
        generator.generate();
    }

    public static final class ConfigAction
    implements TaskConfigAction<GenerateBuildConfig> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "BuildConfig");
        }

        @Override
        public Class<GenerateBuildConfig> getType() {
            return GenerateBuildConfig.class;
        }

        @Override
        public void execute(GenerateBuildConfig generateBuildConfigTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            variantData.generateBuildConfigTask = generateBuildConfigTask;
            GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
            generateBuildConfigTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateBuildConfigTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "buildConfigPackageName", () -> ((GradleVariantConfiguration)variantConfiguration).getOriginalApplicationId());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "appPackageName", () -> ((GradleVariantConfiguration)variantConfiguration).getApplicationId());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "versionName", variantConfiguration::getVersionName);
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "versionCode", variantConfiguration::getVersionCode);
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "debuggable", () -> ((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "buildTypeName", () -> ((CoreBuildType)variantConfiguration.getBuildType()).getName());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "flavorName", () -> ((GradleVariantConfiguration)variantConfiguration).getFlavorName());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "flavorNamesWithDimensionNames", () -> ((GradleVariantConfiguration)variantConfiguration).getFlavorNamesWithDimensionNames());
            ConventionMappingHelper.map((Task)generateBuildConfigTask, "items", () -> ((GradleVariantConfiguration)variantConfiguration).getBuildConfigItems());
            generateBuildConfigTask.setSourceOutputDir(this.scope.getBuildConfigSourceOutputDir());
        }
    }
}

