/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ExternalNativeBaseTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.tasks.TaskAction;

public class ExternalNativeCleanTask
extends ExternalNativeBaseTask {
    private List<File> nativeBuildConfigurationsJsons;

    @TaskAction
    void clean() throws ProcessException, IOException {
        this.diagnostic("starting clean", new Object[0]);
        this.diagnostic("finding existing JSONs", new Object[0]);
        ArrayList existingJsons = Lists.newArrayList();
        for (File json : this.nativeBuildConfigurationsJsons) {
            if (!json.isFile()) continue;
            existingJsons.add(json);
        }
        Collection<NativeBuildConfigValue> configValueList = ExternalNativeBuildTaskUtils.getNativeBuildConfigValues(existingJsons, (String)Preconditions.checkNotNull((Object)this.getVariantName()));
        ArrayList cleanCommands = Lists.newArrayList();
        for (NativeBuildConfigValue config : configValueList) {
            if (config.libraries == null || config.cleanCommands == null) continue;
            cleanCommands.addAll(config.cleanCommands);
        }
        this.diagnostic("about to execute %s clean commands", cleanCommands.size());
        this.executeProcessBatch(cleanCommands);
        this.diagnostic("clean complete", new Object[0]);
    }

    protected void executeProcessBatch(List<String> commands) throws ProcessException {
        for (String command : commands) {
            this.getLogger().lifecycle(String.format("  cleaning %s", this.getName()));
            List tokens = StringHelper.tokenizeString((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                processBuilder.addArgs((String)tokens.get(i));
            }
            this.diagnostic("%s", processBuilder);
            ExternalNativeBuildTaskUtils.executeBuildProcessAndLogError(this.getBuilder(), processBuilder.createProcess());
        }
    }

    public List<File> getNativeBuildConfigurationsJsons() {
        return this.nativeBuildConfigurationsJsons;
    }

    private void setNativeBuildConfigurationsJsons(List<File> nativeBuildConfigurationsJsons) {
        this.nativeBuildConfigurationsJsons = nativeBuildConfigurationsJsons;
    }

    public static class ConfigAction
    implements TaskConfigAction<ExternalNativeCleanTask> {
        private final ExternalNativeJsonGenerator generator;
        private final VariantScope scope;
        private final AndroidBuilder androidBuilder;

        public ConfigAction(ExternalNativeJsonGenerator generator, VariantScope scope, AndroidBuilder androidBuilder) {
            this.generator = generator;
            this.scope = scope;
            this.androidBuilder = androidBuilder;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("externalNativeBuildClean");
        }

        @Override
        public Class<ExternalNativeCleanTask> getType() {
            return ExternalNativeCleanTask.class;
        }

        @Override
        public void execute(ExternalNativeCleanTask task) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            task.setVariantName(variantData.getName());
            ArrayList abiNames = Lists.newArrayList();
            for (Abi abi : NdkHandler.getAbiList()) {
                abiNames.add(abi.getName());
            }
            task.setNativeBuildConfigurationsJsons(ExternalNativeBuildTaskUtils.getOutputJsons(this.generator.getJsonFolder(), abiNames));
            task.setAndroidBuilder(this.androidBuilder);
        }
    }
}

