/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApkVariantImpl;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;

public class ApplicationVariantFactory
implements VariantFactory {
    Instantiator instantiator;
    protected final AndroidConfig extension;
    private final AndroidBuilder androidBuilder;

    public ApplicationVariantFactory(Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        this.instantiator = instantiator;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager) {
        ApplicationVariantData variant = new ApplicationVariantData(this.extension, variantConfiguration, taskManager, this.androidBuilder.getErrorReporter());
        variant.calculateFilters(this.extension.getSplits());
        Set<String> densities = variant.getFilters(OutputFile.FilterType.DENSITY);
        Set<String> abis = variant.getFilters(OutputFile.FilterType.ABI);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(this.extension.getSplits().getDensity().getCompatibleScreens());
        }
        if (variant.getSplitHandlingPolicy() == SplitHandlingPolicy.PRE_21_POLICY) {
            ArrayList<String> orderedDensities = new ArrayList<String>();
            orderedDensities.add(OutputFile.NO_FILTER);
            orderedDensities.addAll(densities);
            ArrayList<String> orderedAbis = new ArrayList<String>();
            if (abis.isEmpty() || this.extension.getSplits().getAbi().isEnable() && this.extension.getSplits().getAbi().isUniversalApk()) {
                orderedAbis.add(OutputFile.NO_FILTER);
            }
            orderedAbis.addAll(abis);
            for (String density : orderedDensities) {
                for (String abi : orderedAbis) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    if (density != null) {
                        builder.add((Object)FilterDataImpl.build(OutputFile.DENSITY, density));
                    }
                    if (abi != null) {
                        builder.add((Object)FilterDataImpl.build(OutputFile.ABI, abi));
                    }
                    variant.createOutput(OutputFile.OutputType.FULL_SPLIT, (Collection<FilterData>)builder.build());
                }
            }
        } else {
            variant.createOutput(OutputFile.OutputType.MAIN, Collections.emptyList());
        }
        return variant;
    }

    @Override
    public ApplicationVariant createVariantApi(BaseVariantData<? extends BaseVariantOutputData> variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        ApplicationVariantImpl variant = (ApplicationVariantImpl)this.instantiator.newInstance(ApplicationVariantImpl.class, new Object[]{variantData, this.androidBuilder, readOnlyObjectProvider});
        ApplicationVariantFactory.createApkOutputApiObjects(this.instantiator, variantData, variant);
        return variant;
    }

    public static void createApkOutputApiObjects(Instantiator instantiator, BaseVariantData<? extends BaseVariantOutputData> variantData, ApkVariantImpl variant) {
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            ApkVariantOutputData apkOutput = (ApkVariantOutputData)baseVariantOutputData;
            ApkVariantOutputImpl output = (ApkVariantOutputImpl)instantiator.newInstance(ApkVariantOutputImpl.class, new Object[]{apkOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
    }

    @Override
    public VariantType getVariantConfigurationType() {
        return VariantType.DEFAULT;
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
    }

    @Override
    public void preVariantWork(Project project) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

