/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ResourceUsageAnalyzer;
import com.android.builder.core.AndroidBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public class ShrinkResourcesTransform
extends Transform {
    private static boolean ourWarned = true;
    private final BaseVariantOutputData variantOutputData;
    private final File uncompressedResources;
    private final File compressedResources;
    private final AndroidBuilder androidBuilder;
    private final Logger logger;
    private final ImmutableList<File> secondaryInputs;
    private final File sourceDir;
    private final File resourceDir;
    private final File mergedManifest;
    private final File mappingFile;

    public ShrinkResourcesTransform(BaseVariantOutputData variantOutputData, File uncompressedResources, File compressedResources, AndroidBuilder androidBuilder, Logger logger) {
        this.variantOutputData = variantOutputData;
        this.uncompressedResources = uncompressedResources;
        this.compressedResources = compressedResources;
        this.androidBuilder = androidBuilder;
        this.logger = logger;
        BaseVariantData<?> variantData = variantOutputData.variantData;
        ProcessAndroidResources processResourcesTask = variantData.generateRClassTask;
        this.sourceDir = processResourcesTask.getSourceOutputDir();
        this.resourceDir = variantData.getScope().getFinalResourcesDir();
        this.mergedManifest = variantOutputData.manifestProcessorTask.getManifestOutputFile();
        this.mappingFile = variantData.getMappingFile();
        this.secondaryInputs = this.mappingFile != null ? ImmutableList.of((Object)uncompressedResources, (Object)this.sourceDir, (Object)this.resourceDir, (Object)this.mergedManifest, (Object)this.mappingFile) : ImmutableList.of((Object)uncompressedResources, (Object)this.sourceDir, (Object)this.resourceDir, (Object)this.mergedManifest);
    }

    public String getName() {
        return "shrinkRes";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<File> getSecondaryFileInputs() {
        return this.secondaryInputs;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return ImmutableList.of((Object)this.compressedResources);
    }

    public boolean isIncremental() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        File logDir;
        TransformInput input = (TransformInput)Iterables.getOnlyElement((Iterable)invocation.getReferencedInputs());
        File minifiedOutJar = ((JarInput)Iterables.getOnlyElement((Iterable)input.getJarInputs())).getFile();
        BaseVariantData<?> variantData = this.variantOutputData.variantData;
        ProcessAndroidResources processResourcesTask = variantData.generateRClassTask;
        File reportFile = null;
        if (this.mappingFile != null && (logDir = this.mappingFile.getParentFile()) != null) {
            reportFile = new File(logDir, "resources.txt");
        }
        ResourceUsageAnalyzer analyzer = new ResourceUsageAnalyzer(this.sourceDir, minifiedOutJar, this.mergedManifest, this.mappingFile, this.resourceDir, reportFile);
        try {
            analyzer.setVerbose(this.logger.isEnabled(LogLevel.INFO));
            analyzer.setDebug(this.logger.isEnabled(LogLevel.DEBUG));
            analyzer.analyze();
            analyzer.rewriteResourceZip(this.uncompressedResources, this.compressedResources);
            int unused = analyzer.getUnusedResourceCount();
            if (unused > 0) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("Removed unused resources");
                long before = this.uncompressedResources.length();
                long after = this.compressedResources.length();
                long percent = (int)((before - after) * 100L / before);
                sb.append(": Binary resource data reduced from ").append(ShrinkResourcesTransform.toKbString(before)).append("KB to ").append(ShrinkResourcesTransform.toKbString(after)).append("KB: Removed ").append(percent).append("%");
                if (!ourWarned) {
                    ourWarned = true;
                    String name = ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).getName();
                    sb.append("\nNote: If necessary, you can disable resource shrinking by adding\nandroid {\n    buildTypes {\n        " + name + " {\n" + "            shrinkResources false\n" + "        }\n" + "    }\n" + "}");
                }
                System.out.println(sb.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Failed to shrink resources: " + e.toString() + "; ignoring");
            this.logger.quiet("Failed to shrink resources: ignoring", (Throwable)e);
        }
        finally {
            analyzer.dispose();
        }
    }

    private static String toKbString(long size) {
        return Integer.toString((int)size / 1024);
    }
}

