/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.internal.InstallUtils;
import com.android.builder.model.ApiVersion;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class InstallVariantTask
extends BaseTask {
    private File adbExe;
    private File splitSelectExe;
    private ProcessExecutor processExecutor;
    private String projectName;
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private BaseVariantData<? extends BaseVariantOutputData> variantData;

    public InstallVariantTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                InstallVariantTask.this.getLogger().debug("Install task is always run.");
                return false;
            }
        });
    }

    @TaskAction
    public void install() throws DeviceException, ProcessException, InterruptedException {
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger(), LogLevel.LIFECYCLE);
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getAdbExe(), this.getTimeOutInMs(), (ILogger)iLogger);
        deviceProvider.init();
        GradleVariantConfiguration variantConfig = this.variantData.getVariantConfiguration();
        String variantName = variantConfig.getFullName();
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (ApiVersion)variantConfig.getMinSdkVersion(), (ILogger)iLogger, (String)this.projectName, (String)variantName)) continue;
            List apkFiles = SplitOutputMatcher.computeBestOutput((ProcessExecutor)this.processExecutor, (File)this.getSplitSelectExe(), (DeviceConfigProvider)new DeviceConfigProviderImpl(device), this.variantData.getOutputs(), this.variantData.getVariantConfiguration().getSupportedAbis());
            if (apkFiles.isEmpty()) {
                this.getLogger().lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), this.projectName, variantName, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                continue;
            }
            this.getLogger().lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), this.projectName, variantName});
            Collection extraArgs = (Collection)Objects.firstNonNull(this.installOptions, (Object)ImmutableList.of());
            if (apkFiles.size() > 1 || device.getApiLevel() >= 21) {
                device.installPackages(apkFiles, extraArgs, this.getTimeOutInMs(), this.getILogger());
                ++successfulInstallCount;
                continue;
            }
            device.installPackage((File)apkFiles.get(0), extraArgs, this.getTimeOutInMs(), this.getILogger());
            ++successfulInstallCount;
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        this.getLogger().quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    @InputFile
    public File getAdbExe() {
        return this.adbExe;
    }

    public void setAdbExe(File adbExe) {
        this.adbExe = adbExe;
    }

    @InputFile
    @Optional
    public File getSplitSelectExe() {
        return this.splitSelectExe;
    }

    public void setSplitSelectExe(File splitSelectExe) {
        this.splitSelectExe = splitSelectExe;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    public BaseVariantData<? extends BaseVariantOutputData> getVariantData() {
        return this.variantData;
    }

    public void setVariantData(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        this.variantData = variantData;
    }

    public static class ConfigAction
    implements TaskConfigAction<InstallVariantTask> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void execute(InstallVariantTask installTask) {
            installTask.setDescription("Installs the " + this.scope.getVariantData().getDescription() + ".");
            installTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            installTask.setGroup("Install");
            installTask.setProjectName(this.scope.getGlobalScope().getProject().getName());
            installTask.setVariantData(this.scope.getVariantData());
            installTask.setTimeOutInMs(this.scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            installTask.setInstallOptions(this.scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            installTask.setProcessExecutor(this.scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            ConventionMappingHelper.map((Task)installTask, "adbExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    SdkInfo info = scope.getGlobalScope().getSdkHandler().getSdkInfo();
                    return info == null ? null : info.getAdb();
                }
            });
            ConventionMappingHelper.map((Task)installTask, "splitSelectExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    String path;
                    TargetInfo info = scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                    String string = path = info == null ? null : info.getBuildTools().getPath(BuildToolInfo.PathId.SPLIT_SELECT);
                    if (path != null) {
                        File splitSelectExe = new File(path);
                        return splitSelectExe.exists() ? splitSelectExe : null;
                    }
                    return null;
                }
            });
            ((ApkVariantData)this.scope.getVariantData()).installTask = installTask;
        }
    }
}

