/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.LibraryImpl;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class JavaLibraryImpl
extends LibraryImpl
implements JavaLibrary,
Serializable {
    private final File jarFile;
    private final List<JavaLibrary> dependencies;

    public JavaLibraryImpl(File jarFile, String project, List<JavaLibrary> dependencies, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isSkipped, boolean isProvided) {
        super(project, requestedCoordinates, resolvedCoordinates, isSkipped, isProvided);
        this.jarFile = jarFile;
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public List<? extends JavaLibrary> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaLibraryImpl that = (JavaLibraryImpl)o;
        return Objects.equal((Object)this.jarFile, (Object)that.jarFile) && Objects.equal(this.dependencies, that.dependencies);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.jarFile, this.dependencies});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("jarFile", (Object)this.jarFile).add("dependencies", this.dependencies).add("super", (Object)super.toString()).toString();
    }
}

