/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstantRunBuildContext {
    private static final Logger LOG = Logging.getLogger(InstantRunBuildContext.class);
    static final String TAG_INSTANT_RUN = "instant-run";
    static final String TAG_BUILD = "build";
    static final String TAG_ARTIFACT = "artifact";
    static final String TAG_TASK = "task";
    static final String ATTR_PLUGIN_VERSION = "plugin-version";
    static final String ATTR_NAME = "name";
    static final String ATTR_DURATION = "duration";
    static final String ATTR_TIMESTAMP = "timestamp";
    static final String ATTR_VERIFIER = "verifier";
    static final String ATTR_TYPE = "type";
    static final String ATTR_LOCATION = "location";
    static final String ATTR_API_LEVEL = "api-level";
    static final String ATTR_DENSITY = "density";
    static final String ATTR_FORMAT = "format";
    static final String ATTR_ABI = "abi";
    static final String ATTR_TOKEN = "token";
    static final String CURRENT_FORMAT = "8";
    private final long[] taskStartTime = new long[TaskType.values().length];
    private final long[] taskDurationInMs = new long[TaskType.values().length];
    private InstantRunPatchingPolicy patchingPolicy;
    private Integer featureLevel = null;
    private String density = null;
    private String abi = null;
    private final Build currentBuild = new Build(System.nanoTime(), Optional.empty());
    private final TreeMap<Long, Build> previousBuilds = new TreeMap();
    private File tmpBuildInfo = null;
    private boolean isInstantRunMode = false;
    private final AtomicLong token = new AtomicLong(0L);
    private InstantRunBuildMode buildMode = InstantRunBuildMode.HOT_WARM;

    public void setInstantRunMode(boolean instantRunMode) {
        this.isInstantRunMode = instantRunMode;
    }

    public boolean isInInstantRunMode() {
        return this.isInstantRunMode;
    }

    public void setTmpBuildInfo(File tmpBuildInfo) {
        this.tmpBuildInfo = tmpBuildInfo;
    }

    public long getBuildId() {
        return this.currentBuild.buildId;
    }

    public void startRecording(TaskType taskType) {
        this.taskStartTime[taskType.ordinal()] = System.currentTimeMillis();
    }

    public long stopRecording(TaskType taskType) {
        long duration;
        this.taskDurationInMs[taskType.ordinal()] = duration = System.currentTimeMillis() - this.taskStartTime[taskType.ordinal()];
        return duration;
    }

    public void setVerifierResult(InstantRunVerifierStatus verifierStatus) {
        InstantRunVerifierStatus currentVerifierStatus = this.currentBuild.getVerifierStatus().orElse(InstantRunVerifierStatus.COMPATIBLE);
        LOG.info("Receiving verifier result: {}. Current Verifier/Build mode is {}/{}.", new Object[]{verifierStatus, currentVerifierStatus, this.buildMode});
        InstantRunBuildMode newBuildMode = this.buildMode.combine(verifierStatus.getInstantRunBuildModeForPatchingPolicy(this.patchingPolicy));
        if (currentVerifierStatus == InstantRunVerifierStatus.COMPATIBLE || newBuildMode != this.buildMode) {
            this.currentBuild.verifierStatus = Optional.of(verifierStatus);
            this.buildMode = newBuildMode;
        }
        LOG.info("Verifier result is now : {}. Build mode is now {}.", (Object)this.currentBuild.getVerifierStatus().orElse(InstantRunVerifierStatus.COMPATIBLE), (Object)this.buildMode);
    }

    public Optional<InstantRunVerifierStatus> getVerifierResult() {
        return this.currentBuild.getVerifierStatus();
    }

    public boolean hasPassedVerification() {
        return !this.currentBuild.verifierStatus.isPresent() || this.currentBuild.verifierStatus.get() == InstantRunVerifierStatus.COMPATIBLE;
    }

    public void setApiLevel(int featureLevel, String coldswapMode, String targetAbi) {
        this.featureLevel = featureLevel;
        this.patchingPolicy = InstantRunPatchingPolicy.getPatchingPolicy(featureLevel, coldswapMode, targetAbi);
        this.abi = targetAbi;
    }

    public int getFeatureLevel() {
        return (Integer)Preconditions.checkNotNull((Object)this.featureLevel, (Object)"setApiLevel should be called before any other actions.");
    }

    public String getDensity() {
        return this.density;
    }

    public void setDensity(String density) {
        this.density = density;
    }

    public InstantRunPatchingPolicy getPatchingPolicy() {
        return this.patchingPolicy;
    }

    public InstantRunBuildMode getBuildMode() {
        return this.buildMode;
    }

    public synchronized void addChangedFile(FileType fileType, File file) throws IOException {
        if (this.patchingPolicy == null) {
            return;
        }
        if (!this.currentBuild.verifierStatus.isPresent()) {
            this.currentBuild.verifierStatus = Optional.of(InstantRunVerifierStatus.COMPATIBLE);
        }
        for (Artifact artifact : this.currentBuild.artifacts) {
            if (artifact.getType() != fileType || !artifact.getLocation().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return;
        }
        if (fileType != FileType.RELOAD_DEX && fileType != FileType.MAIN && fileType != FileType.RESOURCES) {
            switch (this.patchingPolicy) {
                case PRE_LOLLIPOP: {
                    if (fileType == FileType.RESTART_DEX) break;
                    return;
                }
                case MULTI_DEX: {
                    if (fileType == FileType.DEX) break;
                    return;
                }
                case MULTI_APK: {
                    if (fileType == FileType.SPLIT) break;
                    return;
                }
            }
        }
        if (fileType == FileType.MAIN) {
            Artifact previousArtifact;
            if (this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
                fileType = FileType.SPLIT_MAIN;
            }
            if ((previousArtifact = this.currentBuild.getArtifactForType(fileType)) != null) {
                this.currentBuild.artifacts.remove(previousArtifact);
            }
            if (this.patchingPolicy == InstantRunPatchingPolicy.MULTI_DEX) {
                this.currentBuild.artifacts.clear();
            }
            Artifact resourcesApFile = this.currentBuild.getArtifactForType(FileType.RESOURCES);
            while (resourcesApFile != null) {
                this.currentBuild.artifacts.remove(resourcesApFile);
                resourcesApFile = this.currentBuild.getArtifactForType(FileType.RESOURCES);
            }
        }
        this.currentBuild.artifacts.add(new Artifact(fileType, file));
        try {
            this.writeTmpBuildInfo();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    public Build getLastBuild() {
        return this.previousBuilds.isEmpty() ? null : this.previousBuilds.lastEntry().getValue();
    }

    public Artifact getPastBuildsArtifactForType(FileType fileType) {
        for (Build build : this.previousBuilds.values()) {
            Artifact artifact = build.getArtifactForType(fileType);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public long getSecretToken() {
        return this.token.get();
    }

    public void setSecretToken(long token) {
        this.token.set(token);
    }

    @VisibleForTesting
    public Collection<Build> getPreviousBuilds() {
        return this.previousBuilds.values();
    }

    private void purge() {
        boolean foundColdRestart = false;
        HashSet<String> splitFilesAlreadyFound = new HashSet<String>();
        Long initialFullBuild = this.previousBuilds.firstKey();
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Artifact resourceApArtifact;
            Build previousBuild = this.previousBuilds.get(aBuildId);
            if (previousBuild.buildId == initialFullBuild) continue;
            if (previousBuild.verifierStatus.isPresent()) {
                if (previousBuild.verifierStatus.get() == InstantRunVerifierStatus.COMPATIBLE) {
                    if (foundColdRestart) {
                        this.previousBuilds.remove(aBuildId);
                        continue;
                    }
                } else {
                    foundColdRestart = true;
                }
            } else {
                foundColdRestart = previousBuild.hasCodeArtifact();
            }
            if (foundColdRestart && this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK && (resourceApArtifact = previousBuild.getArtifactForType(FileType.RESOURCES)) != null) {
                previousBuild.artifacts.remove(resourceApArtifact);
            }
            for (Artifact artifact : new ArrayList(previousBuild.artifacts)) {
                if (!artifact.isAccumulative()) continue;
                if (splitFilesAlreadyFound.contains(artifact.getLocation().getAbsolutePath())) {
                    previousBuild.artifacts.remove(artifact);
                    continue;
                }
                splitFilesAlreadyFound.add(artifact.getLocation().getAbsolutePath());
            }
        }
        for (Long aBuildId : new ArrayList<Long>(this.previousBuilds.descendingKeySet())) {
            Build aBuild = this.previousBuilds.get(aBuildId);
            if (!aBuild.artifacts.isEmpty() || aBuild.buildId == this.currentBuild.buildId) continue;
            this.previousBuilds.remove(aBuildId);
        }
        if (this.buildMode == InstantRunBuildMode.FULL) {
            this.collapseMainArtifactsIntoCurrentBuild();
        }
    }

    private void collapseMainArtifactsIntoCurrentBuild() {
        if (this.patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
            HashSet splitLocations = Sets.newHashSet();
            Artifact main = null;
            for (Build build : this.previousBuilds.values()) {
                for (Artifact artifact : build.artifacts) {
                    if (artifact.fileType == FileType.SPLIT) {
                        splitLocations.add(artifact.location.getAbsolutePath());
                        continue;
                    }
                    if (artifact.fileType != FileType.SPLIT_MAIN) continue;
                    main = artifact;
                }
            }
            for (Artifact artifact : this.currentBuild.artifacts) {
                if (artifact.fileType == FileType.SPLIT) {
                    splitLocations.remove(artifact.location.getAbsolutePath());
                    continue;
                }
                if (artifact.fileType != FileType.SPLIT_MAIN) continue;
                main = null;
            }
            for (String splitLocation : splitLocations) {
                this.currentBuild.artifacts.add(new Artifact(FileType.SPLIT, new File(splitLocation)));
            }
            if (main != null) {
                this.currentBuild.artifacts.add(main);
            }
        } else if (this.currentBuild.artifacts.isEmpty()) {
            Artifact main = null;
            for (Build build : this.previousBuilds.values()) {
                for (Artifact artifact : build.artifacts) {
                    if (artifact.fileType != FileType.MAIN) continue;
                    main = artifact;
                }
            }
            if (main == null) {
                throw new IllegalStateException("No current or previous main artifacts. This should not happen.");
            }
            this.currentBuild.artifacts.add(main);
        }
        if (this.currentBuild.artifacts.isEmpty()) {
            throw new IllegalStateException("Full build with no artifacts. This should not happen.");
        }
    }

    public void loadFromXmlFile(File persistedState) throws IOException, ParserConfigurationException, SAXException {
        if (!persistedState.exists()) {
            this.setVerifierResult(InstantRunVerifierStatus.INITIAL_BUILD);
            return;
        }
        this.loadFromDocument(XmlUtils.parseUtfXmlFile((File)persistedState, (boolean)false));
    }

    public void loadFromXml(String persistedState) throws IOException, SAXException, ParserConfigurationException {
        this.loadFromDocument(XmlUtils.parseDocument((String)persistedState, (boolean)false));
    }

    private void loadFromDocument(Document document) {
        Element instantRun = document.getDocumentElement();
        if (!String.valueOf(this.getFeatureLevel()).equals(instantRun.getAttribute(ATTR_API_LEVEL))) {
            Logging.getLogger(InstantRunBuildContext.class).quiet("Instant Run: Target device API level has changed.");
            this.setVerifierResult(InstantRunVerifierStatus.INITIAL_BUILD);
            return;
        }
        if (!"2.2.0".equals(instantRun.getAttribute(ATTR_PLUGIN_VERSION))) {
            Logging.getLogger(InstantRunBuildContext.class).quiet("Instant Run: Android plugin version has changed.");
            this.setVerifierResult(InstantRunVerifierStatus.INITIAL_BUILD);
            return;
        }
        String tokenString = instantRun.getAttribute(ATTR_TOKEN);
        if (!Strings.isNullOrEmpty((String)tokenString)) {
            this.token.set(Long.parseLong(tokenString));
        }
        Build lastBuild = Build.fromXml(instantRun);
        this.previousBuilds.put(lastBuild.buildId, lastBuild);
        NodeList buildNodes = instantRun.getChildNodes();
        for (int i = 0; i < buildNodes.getLength(); ++i) {
            Node buildNode = buildNodes.item(i);
            if (!buildNode.getNodeName().equals(TAG_BUILD)) continue;
            Build build = Build.fromXml(buildNode);
            this.previousBuilds.put(build.buildId, build);
        }
    }

    public void mergeFromFile(File tmpBuildInfoFile) throws IOException, SAXException, ParserConfigurationException {
        if (!tmpBuildInfoFile.exists()) {
            return;
        }
        this.mergeFrom(XmlUtils.parseUtfXmlFile((File)tmpBuildInfoFile, (boolean)false));
    }

    public void mergeFrom(String tmpBuildInfo) throws IOException, SAXException, ParserConfigurationException {
        this.mergeFrom(XmlUtils.parseDocument((String)tmpBuildInfo, (boolean)false));
    }

    private void mergeFrom(Document document) throws IOException {
        Element instantRun = document.getDocumentElement();
        Build lastBuild = Build.fromXml(instantRun);
        for (Artifact previousArtifact : lastBuild.getArtifacts()) {
            this.mergeArtifact(previousArtifact);
        }
    }

    private void mergeArtifact(Artifact stashedArtifact) {
        for (Artifact artifact : this.currentBuild.artifacts) {
            if (artifact.getType() != stashedArtifact.getType() || !artifact.getLocation().getAbsolutePath().equals(stashedArtifact.getLocation().getAbsolutePath())) continue;
            return;
        }
        this.currentBuild.getArtifacts().add(stashedArtifact);
    }

    public void close() {
        this.previousBuilds.put(this.currentBuild.buildId, this.currentBuild);
        this.purge();
    }

    public String toXml() throws ParserConfigurationException {
        return this.toXml(this.buildMode == InstantRunBuildMode.FULL ? PersistenceMode.FULL_BUILD : PersistenceMode.INCREMENTAL_BUILD);
    }

    @VisibleForTesting
    String toXml(PersistenceMode persistenceMode) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.toXml(document, persistenceMode);
        return XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
    }

    private Element toXml(Document document, PersistenceMode persistenceMode) {
        Element instantRun = document.createElement(TAG_INSTANT_RUN);
        document.appendChild(instantRun);
        for (TaskType taskType : TaskType.values()) {
            Element taskTypeNode = document.createElement(TAG_TASK);
            taskTypeNode.setAttribute(ATTR_NAME, (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)taskType.name()));
            taskTypeNode.setAttribute(ATTR_DURATION, String.valueOf(this.taskDurationInMs[taskType.ordinal()]));
            instantRun.appendChild(taskTypeNode);
        }
        this.currentBuild.toXml(document, instantRun);
        instantRun.setAttribute(ATTR_API_LEVEL, String.valueOf(this.getFeatureLevel()));
        if (this.density != null) {
            instantRun.setAttribute(ATTR_DENSITY, this.density);
        }
        if (this.abi != null) {
            instantRun.setAttribute(ATTR_ABI, this.abi);
        }
        if (this.token != null) {
            instantRun.setAttribute(ATTR_TOKEN, this.token.toString());
        }
        instantRun.setAttribute(ATTR_FORMAT, CURRENT_FORMAT);
        instantRun.setAttribute(ATTR_PLUGIN_VERSION, "2.2.0");
        switch (persistenceMode) {
            case FULL_BUILD: {
                if (this.previousBuilds.isEmpty()) break;
                instantRun.appendChild(this.previousBuilds.lastEntry().getValue().toXml(document));
                break;
            }
            case INCREMENTAL_BUILD: {
                for (Build build : this.previousBuilds.values()) {
                    instantRun.appendChild(build.toXml(document));
                }
                break;
            }
            case TEMP_BUILD: {
                break;
            }
            default: {
                throw new RuntimeException("PersistenceMode not handled" + (Object)((Object)persistenceMode));
            }
        }
        return instantRun;
    }

    private void writeTmpBuildInfo() throws ParserConfigurationException, IOException {
        if (this.tmpBuildInfo == null) {
            return;
        }
        Files.createParentDirs((File)this.tmpBuildInfo);
        Files.write((CharSequence)this.toXml(PersistenceMode.TEMP_BUILD), (File)this.tmpBuildInfo, (Charset)Charsets.UTF_8);
    }

    @VisibleForTesting
    static enum PersistenceMode {
        FULL_BUILD,
        INCREMENTAL_BUILD,
        TEMP_BUILD;

    }

    public static class Artifact {
        private final FileType fileType;
        private File location;

        public Artifact(FileType fileType, File location) {
            this.fileType = fileType;
            this.location = location;
        }

        public Node toXml(Document document) {
            Element artifact = document.createElement(InstantRunBuildContext.TAG_ARTIFACT);
            artifact.setAttribute(InstantRunBuildContext.ATTR_TYPE, this.fileType.name());
            artifact.setAttribute(InstantRunBuildContext.ATTR_LOCATION, XmlUtils.toXmlAttributeValue((String)this.location.getAbsolutePath()));
            return artifact;
        }

        public static Artifact fromXml(Node artifactNode) {
            NamedNodeMap attributes = artifactNode.getAttributes();
            return new Artifact(FileType.valueOf(attributes.getNamedItem(InstantRunBuildContext.ATTR_TYPE).getNodeValue()), new File(attributes.getNamedItem(InstantRunBuildContext.ATTR_LOCATION).getNodeValue()));
        }

        public File getLocation() {
            return this.location;
        }

        public boolean isAccumulative() {
            return this.fileType != FileType.RELOAD_DEX;
        }

        public void setLocation(File location) {
            this.location = location;
        }

        public FileType getType() {
            return this.fileType;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fileType", (Object)this.fileType).add(InstantRunBuildContext.ATTR_LOCATION, (Object)this.location).toString();
        }
    }

    public static class Build {
        private final long buildId;
        private Optional<InstantRunVerifierStatus> verifierStatus;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public Build(long buildId, Optional<InstantRunVerifierStatus> verifierStatus) {
            this.buildId = buildId;
            this.verifierStatus = verifierStatus;
        }

        public Artifact getArtifactForType(FileType fileType) {
            for (Artifact artifact : this.artifacts) {
                if (artifact.fileType != fileType) continue;
                return artifact;
            }
            return null;
        }

        private boolean hasCodeArtifact() {
            for (Artifact artifact : this.artifacts) {
                FileType type = artifact.getType();
                if (type != FileType.DEX && type != FileType.SPLIT && type != FileType.MAIN && type != FileType.RESTART_DEX) continue;
                return true;
            }
            return false;
        }

        private Element toXml(Document document) {
            Element build = document.createElement(InstantRunBuildContext.TAG_BUILD);
            this.toXml(document, build);
            return build;
        }

        private void toXml(Document document, Element element) {
            element.setAttribute(InstantRunBuildContext.ATTR_TIMESTAMP, String.valueOf(this.buildId));
            if (this.verifierStatus.isPresent()) {
                element.setAttribute(InstantRunBuildContext.ATTR_VERIFIER, this.verifierStatus.get().name());
            }
            for (Artifact artifact : this.artifacts) {
                element.appendChild(artifact.toXml(document));
            }
        }

        public static Build fromXml(Node buildNode) {
            NamedNodeMap attributes = buildNode.getAttributes();
            Node verifierAttribute = attributes.getNamedItem(InstantRunBuildContext.ATTR_VERIFIER);
            Build build = new Build(Long.parseLong(attributes.getNamedItem(InstantRunBuildContext.ATTR_TIMESTAMP).getNodeValue()), verifierAttribute != null ? Optional.of(InstantRunVerifierStatus.valueOf(verifierAttribute.getNodeValue())) : Optional.empty());
            NodeList childNodes = buildNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node artifactNode = childNodes.item(i);
                if (!artifactNode.getNodeName().equals(InstantRunBuildContext.TAG_ARTIFACT)) continue;
                Artifact artifact = Artifact.fromXml(artifactNode);
                build.artifacts.add(artifact);
            }
            return build;
        }

        public long getBuildId() {
            return this.buildId;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public Optional<InstantRunVerifierStatus> getVerifierStatus() {
            return this.verifierStatus;
        }
    }

    public static enum FileType {
        MAIN,
        SPLIT_MAIN,
        RELOAD_DEX,
        RESTART_DEX,
        DEX,
        SPLIT,
        RESOURCES;

    }

    public static enum TaskType {
        JAVAC,
        INSTANT_RUN_DEX,
        INSTANT_RUN_TRANSFORM,
        VERIFIER;

    }
}

