/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import icons.GoogleLoginIcons;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public final class GoogleLoginActionButton
extends ActionButton {
    private static final String SIGN_IN_MESSAGE = "Sign in to Google...";

    public GoogleLoginActionButton(AnAction action, Presentation presentation, String place, @NotNull Dimension minimumSize) {
        super(action, presentation, place, minimumSize);
        GoogleLogin.getInstance().setLoginMenuItemContribution(this);
        this.updateUi();
    }

    public void updateUi() {
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        if (activeUser == null) {
            this.setToolTipText(SIGN_IN_MESSAGE);
            this.myPresentation.setDescription(SIGN_IN_MESSAGE);
            this.myPresentation.setIcon(GoogleLoginIcons.DEFAULT_USER_AVATAR);
        } else {
            this.setToolTipText(activeUser.getEmail());
            this.myPresentation.setDescription(activeUser.getEmail());
            Image image = activeUser.getPicture();
            if (image == null) {
                this.myPresentation.setIcon(GoogleLoginIcons.DEFAULT_USER_AVATAR);
            } else {
                Image scaledImage = image.getScaledInstance(16, 16, 4);
                this.myPresentation.setIcon((Icon)new ImageIcon(scaledImage));
            }
        }
    }
}

