/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.editor.DefaultActivityLaunch;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.Lists;
import com.google.gct.testrecorder.debugger.SessionInitializer;
import com.google.gct.testrecorder.util.TestRecorderTracking;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class TestRecorderAction
extends AnAction {
    public static final Icon TEST_RECORDER_ICON = IconLoader.getIcon((String)"circle_small.png", TestRecorderAction.class);
    private Project myProject;

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setIcon(TEST_RECORDER_ICON);
        Project project = event.getProject();
        if (project == null || !project.isInitialized() || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    public void actionPerformed(final AnActionEvent event) {
        UsageTracker.getInstance().trackEvent("com.google.test.recorder", "launch.test.recorder", TestRecorderTracking.SESSION_LABEL, null);
        this.myProject = event.getProject();
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        List<AndroidRunConfiguration> suitableRunConfigurations = this.getSuitableRunConfigurations();
        if (suitableRunConfigurations.isEmpty()) {
            String message = "Please create an Android Application configuration with a valid module and Default or Specified launch activity.";
            Messages.showDialog((Project)this.myProject, (String)message, (String)"No suitable Android Application configuration found", (String[])new String[]{"OK"}, (int)0, null);
            return;
        }
        if (suitableRunConfigurations.size() == 1) {
            this.launchTestRecorder(event, suitableRunConfigurations.get(0));
        } else {
            RunnerAndConfigurationSettings selectedConfiguration = RunManagerEx.getInstanceEx((Project)this.myProject).getSelectedConfiguration();
            if (selectedConfiguration != null && suitableRunConfigurations.contains(selectedConfiguration.getConfiguration())) {
                this.launchTestRecorder(event, (AndroidRunConfiguration)selectedConfiguration.getConfiguration());
            } else {
                ListPopupImpl configurationPickerPopup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<AndroidRunConfiguration>("Pick configuration to launch", suitableRunConfigurations){

                    @NotNull
                    public String getTextFor(AndroidRunConfiguration runConfiguration) {
                        return runConfiguration.getName();
                    }

                    public PopupStep onChosen(final AndroidRunConfiguration runConfiguration, boolean finalChoice) {
                        return this.doFinalStep(new Runnable(){

                            @Override
                            public void run() {
                                TestRecorderAction.this.launchTestRecorder(event, runConfiguration);
                            }
                        });
                    }
                });
                configurationPickerPopup.showCenteredInCurrentWindow(this.myProject);
            }
        }
    }

    private void launchTestRecorder(AnActionEvent event, AndroidRunConfiguration runConfiguration) {
        final AndroidRunConfiguration testRecorderConfiguration = (AndroidRunConfiguration)runConfiguration.clone();
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Project)testRecorderConfiguration.getProject(), (Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunProfile)testRecorderConfiguration);
        if (builder == null) {
            throw new RuntimeException("Could not create execution environment builder!");
        }
        Module module = ((JavaRunConfigurationModule)testRecorderConfiguration.getConfigurationModule()).getModule();
        final AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            throw new RuntimeException("Could not obtain Android facet for module: " + module.getName());
        }
        final LaunchOptionState launchOptionState = runConfiguration.getLaunchOptionState(runConfiguration.MODE);
        final ExecutionEnvironment environment = builder.activeTarget().dataContext(event.getDataContext()).build();
        AndroidSessionInfo oldSessionInfo = AndroidSessionInfo.findOldSession((Project)module.getProject(), null, (int)runConfiguration.getUniqueID());
        if (oldSessionInfo != null) {
            oldSessionInfo.getProcessHandler().detachProcess();
        }
        try {
            environment.getRunner().execute(environment, new ProgramRunner.Callback(){

                public void processStarted(RunContentDescriptor descriptor) {
                    ApplicationManager.getApplication().executeOnPooledThread((Runnable)new SessionInitializer(facet, environment, launchOptionState, testRecorderConfiguration.getUniqueID()));
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Could not start debugging of the app: ", e);
        }
    }

    private List<AndroidRunConfiguration> getSuitableRunConfigurations() {
        LinkedList suitableRunConfigurations = Lists.newLinkedList();
        for (RunConfiguration runConfiguration : RunManagerEx.getInstanceEx((Project)this.myProject).getAllConfigurationsList()) {
            LaunchOptionState launchOptionState;
            AndroidRunConfiguration androidRunConfiguration;
            if (runConfiguration == null || !(runConfiguration.getType() instanceof AndroidRunConfigurationType) || ((JavaRunConfigurationModule)(androidRunConfiguration = (AndroidRunConfiguration)runConfiguration).getConfigurationModule()).getModule() == null || !((launchOptionState = androidRunConfiguration.getLaunchOptionState(androidRunConfiguration.MODE)) instanceof DefaultActivityLaunch.State) && !(launchOptionState instanceof SpecificActivityLaunch.State)) continue;
            suitableRunConfigurations.add(androidRunConfiguration);
        }
        return suitableRunConfigurations;
    }
}

