/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.event;

import com.google.common.collect.Sets;
import com.google.gct.testrecorder.event.ElementAction;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class TestRecorderEvent
extends ElementAction {
    public static final String VIEW_CLICK = "VIEW_CLICKED";
    public static final String VIEW_LONG_CLICK = "VIEW_LONG_CLICKED";
    public static final String LIST_ITEM_CLICK = "LIST_ITEM_CLICKED";
    public static final String TEXT_CHANGE = "VIEW_TEXT_CHANGED";
    public static final String PRESS_BACK = "PRESSED_BACK";
    public static final String PRESS_EDITOR_ACTION = "PRESSED_EDITOR_ACTION";
    public static final HashSet<String> SUPPORTED_EVENTS = Sets.newHashSet((Object[])new String[]{"VIEW_CLICKED", "VIEW_LONG_CLICKED", "LIST_ITEM_CLICKED", "VIEW_TEXT_CHANGED", "PRESSED_BACK", "PRESSED_EDITOR_ACTION"});
    private final String eventType;
    private final long timestamp;
    private boolean isChecked;
    private String replacementText;
    private int recyclerViewPosition = -1;
    private int actionCode = -1;

    public TestRecorderEvent(String eventType, long timestamp) {
        this.eventType = eventType;
        this.timestamp = timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public int getRecyclerViewPosition() {
        return this.recyclerViewPosition;
    }

    public int getActionCode() {
        return this.actionCode;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public void setReplacementText(String replacementText) {
        this.replacementText = replacementText;
    }

    public void setRecyclerViewPosition(int recyclerViewPosition) {
        this.recyclerViewPosition = recyclerViewPosition;
    }

    public void setActionCode(int actionCode) {
        this.actionCode = actionCode;
    }

    public boolean isViewClick() {
        return VIEW_CLICK.equals(this.eventType);
    }

    public boolean isViewLongClick() {
        return VIEW_LONG_CLICK.equals(this.eventType);
    }

    public boolean isListItemClick() {
        return LIST_ITEM_CLICK.equals(this.eventType);
    }

    public boolean isClickEvent() {
        return this.isViewClick() || this.isViewLongClick() || this.isListItemClick();
    }

    public boolean isTextChange() {
        return TEXT_CHANGE.equals(this.eventType);
    }

    public boolean isPressBack() {
        return PRESS_BACK.equals(this.eventType);
    }

    public boolean isPressEditorAction() {
        return PRESS_EDITOR_ACTION.equals(this.eventType);
    }

    public boolean isPressEvent() {
        return this.isPressBack() || this.isPressEditorAction();
    }

    @Override
    public String getRendererString() {
        if (this.isPressEvent()) {
            return this.getIdAttributeDisplayPresentation("", this.isPressBack() ? "Back" : this.getRendererActionCode());
        }
        if (this.recyclerViewPosition != -1) {
            return this.getRendererString(this.getIdAttributeDisplayPresentation("element position", String.valueOf(this.recyclerViewPosition)));
        }
        return super.getRendererString();
    }

    private String getRendererActionCode() {
        switch (this.actionCode) {
            case 2: {
                return "Go";
            }
            case 3: {
                return "Search";
            }
            case 4: {
                return "Send";
            }
            case 5: {
                return "Next";
            }
            case 6: {
                return "Done";
            }
            case 7: {
                return "Previous";
            }
        }
        return "Return";
    }

    @Override
    @NotNull
    protected String getRendererString(String displayElementAttribute) {
        String prefix = this.isTextChange() ? "into " : "";
        return prefix + super.getRendererString(displayElementAttribute);
    }

    public boolean canMerge(TestRecorderEvent eventToMergeWith) {
        return this.isTextChange() && eventToMergeWith.isTextChange() && this.getElementResourceId().equals(eventToMergeWith.getElementResourceId()) && this.getReplacementText().equals(eventToMergeWith.getElementText());
    }
}

