/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.debugger;

import com.google.gct.testrecorder.debugger.BreakpointDescriptor;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.event.TestRecorderEventListener;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.jdi.StringReferenceImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointCommand
extends DebuggerCommandImpl {
    private static final Logger LOGGER = Logger.getInstance(BreakpointCommand.class);
    private static final int MAX_PARENT_HIERARCHY_EVALUATION_DEPTH = 3;
    private static final int MAX_PARENT_HIERARCHY_SCROLL_EVALUATION_DEPTH = 5;
    private static final String PARENT_NODE_CALL = ".getParent()";
    private final DebugProcessImpl myDebugProcess;
    private final BreakpointDescriptor myBreakpointDescriptor;
    private volatile TestRecorderEventListener myEventListener;
    private static TestRecorderEvent preparatoryTextChangeEvent;

    public BreakpointCommand(DebugProcessImpl debugProcess, BreakpointDescriptor breakpointDescriptor) {
        this.myDebugProcess = debugProcess;
        this.myBreakpointDescriptor = breakpointDescriptor;
    }

    protected void action() throws Exception {
        Location location = this.getBreakpointLocation();
        BreakpointRequest request = this.myDebugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)new FilteredRequestorAdapter(){

            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
                try {
                    SuspendContextImpl suspendContext = action.getSuspendContext();
                    suspendContext.initExecutionStacks(suspendContext.getThread());
                    JavaStackFrame stackFrame = (JavaStackFrame)suspendContext.getActiveExecutionStack().getTopFrame();
                    StackFrameProxyImpl frameProxy = stackFrame.getStackFrameProxy();
                    ObjectReference objectReference = frameProxy.thisObject();
                    EvaluationContextImpl evalContext = new EvaluationContextImpl(suspendContext, frameProxy, (Value)objectReference);
                    NodeManagerImpl nodeManager = BreakpointCommand.this.myDebugProcess.getXdebugProcess().getNodeManager();
                    if (((BreakpointCommand)BreakpointCommand.this).myBreakpointDescriptor.eventType.equals("VIEW_TEXT_CHANGED")) {
                        if (((BreakpointCommand)BreakpointCommand.this).myBreakpointDescriptor.isPreparatory) {
                            preparatoryTextChangeEvent = BreakpointCommand.this.prepareEvent(evalContext, nodeManager);
                        } else {
                            if (preparatoryTextChangeEvent == null) {
                                throw new RuntimeException("Mandatory preparatory text change event is missing!");
                            }
                            String receiverReference = BreakpointCommand.this.getReceiverReference(evalContext, nodeManager);
                            Value text = BreakpointCommand.this.evaluateExpression(receiverReference + ".getText().toString()", evalContext, nodeManager);
                            preparatoryTextChangeEvent.setReplacementText(text == null ? "" : BreakpointCommand.this.getStringValue(text));
                            BreakpointCommand.this.notifyEventListener(preparatoryTextChangeEvent);
                            preparatoryTextChangeEvent = null;
                        }
                    } else {
                        BreakpointCommand.this.notifyEventListener(BreakpointCommand.this.prepareEvent(evalContext, nodeManager));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to process breakpoint event", (Throwable)e);
                }
                return false;
            }
        }, location);
        this.myDebugProcess.getRequestsManager().enableRequest((EventRequest)request);
    }

    private void notifyEventListener(TestRecorderEvent event) {
        if (this.myEventListener != null && event != null) {
            this.myEventListener.onEvent(event);
        }
    }

    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    public void setEventListener(TestRecorderEventListener listener) {
        this.myEventListener = listener;
    }

    private Location getBreakpointLocation() {
        List referenceTypes = this.myDebugProcess.getVirtualMachineProxy().classesByName(this.myBreakpointDescriptor.className);
        if (referenceTypes.isEmpty()) {
            throw new RuntimeException("Could not find class " + this.myBreakpointDescriptor.className);
        }
        if (referenceTypes.size() > 1) {
            throw new RuntimeException("Found more than one copy of class " + this.myBreakpointDescriptor.className);
        }
        List<Method> methods = ((ReferenceType)referenceTypes.get(0)).methodsByName(this.myBreakpointDescriptor.methodName, this.myBreakpointDescriptor.methodSignature);
        if (methods.isEmpty()) {
            throw new RuntimeException("Could not find method " + this.myBreakpointDescriptor.methodName + this.myBreakpointDescriptor.methodSignature + " in class " + this.myBreakpointDescriptor.className);
        }
        if (methods.size() > 1) {
            throw new RuntimeException("Found more than one copy of method " + this.myBreakpointDescriptor.methodName + this.myBreakpointDescriptor.methodSignature + " in class " + this.myBreakpointDescriptor.className);
        }
        return methods.get(0).location();
    }

    @Nullable
    private TestRecorderEvent prepareEvent(EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        TestRecorderEvent event = new TestRecorderEvent(this.myBreakpointDescriptor.eventType, System.currentTimeMillis());
        if (event.isPressEvent()) {
            if (event.isPressBack()) {
                Value isKeyCodeBackActionUp = this.evaluateExpression("p.mEvent.mKeyCode == android.view.KeyEvent.KEYCODE_BACK && p.mEvent.mAction == android.view.KeyEvent.ACTION_UP", evalContext, nodeManager);
                if (isKeyCodeBackActionUp != null && Boolean.parseBoolean(this.getStringValue(isKeyCodeBackActionUp))) {
                    return event;
                }
                return null;
            }
            Value actionCode = this.evaluateExpression("actionCode", evalContext, nodeManager);
            if (actionCode != null) {
                event.setActionCode(Integer.parseInt(this.getStringValue(actionCode)));
            }
        }
        String receiverReference = this.getReceiverReference(evalContext, nodeManager);
        this.populateElementDescriptors(event, evalContext, nodeManager, receiverReference, 1);
        if (event.getElementDescriptorsCount() > 0) {
            event.setReplacementText(event.getElementDescriptor(0).getText());
        }
        this.setScrollableState(event, evalContext, nodeManager, receiverReference + PARENT_NODE_CALL, 2);
        return event;
    }

    @NotNull
    private String getReceiverReference(EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        if (this.myBreakpointDescriptor.eventType.equals("VIEW_CLICKED") || this.myBreakpointDescriptor.eventType.equals("VIEW_TEXT_CHANGED")) {
            return "this.this$0";
        }
        if (this.myBreakpointDescriptor.eventType.equals("LIST_ITEM_CLICKED")) {
            String titleViewReference = "view.mTitleView";
            Value titleView = this.evaluateExpression(titleViewReference, evalContext, nodeManager);
            if (titleView != null) {
                return titleViewReference;
            }
            return "view";
        }
        return "this";
    }

    private void setScrollableState(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, int level) {
        String parentElementType;
        if (level > 5) {
            return;
        }
        Value parentElementTypeValue = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager);
        if (parentElementTypeValue != null && ("android.widget.ScrollView".equals(parentElementType = this.getStringValue(parentElementTypeValue)) || "android.widget.HorizontalScrollView".equals(parentElementType))) {
            event.setCanScrollTo(true);
            return;
        }
        this.setScrollableState(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
    }

    private void populateElementDescriptors(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, int level) {
        Value positionIndex;
        String parentReference;
        Value parentElementType;
        if (level > 3) {
            return;
        }
        if (event.isViewClick() && level == 1 && (parentElementType = this.evaluateExpression((parentReference = objectReference + PARENT_NODE_CALL) + ".getClass().getCanonicalName()", evalContext, nodeManager)) != null && "android.support.v7.widget.RecyclerView".equals(this.getStringValue(parentElementType)) && (positionIndex = this.evaluateExpression(objectReference + ".getLayoutParams().mViewHolder.getAdapterPosition()", evalContext, nodeManager)) != null) {
            event.setRecyclerViewPosition(Integer.parseInt(this.getStringValue(positionIndex)));
            objectReference = parentReference;
        }
        if (this.evaluateAndAddElementDescriptor(event, evalContext, nodeManager, objectReference, false)) {
            this.populateElementDescriptors(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
        } else if (level == 1) {
            Value className;
            Value childrenCount = this.evaluateExpression(objectReference + ".mChildrenCount", evalContext, nodeManager);
            if (childrenCount != null) {
                for (int i = 0; i < Integer.parseInt(this.getStringValue(childrenCount)); ++i) {
                    String childReference = objectReference + ".mChildren[" + i + "]";
                    if (!this.evaluateAndAddElementDescriptor(event, evalContext, nodeManager, childReference, true)) continue;
                    return;
                }
            }
            event.addElementDescriptor(new ElementDescriptor((className = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager)) == null ? "" : this.getStringValue(className), -1, "", "", ""));
            this.populateElementDescriptors(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
        }
    }

    private boolean evaluateAndAddElementDescriptor(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, boolean isTextMandatory) {
        Value text = this.evaluateExpression(objectReference + ".getText().toString()", evalContext, nodeManager);
        if (isTextMandatory && text == null) {
            return false;
        }
        Value childPosition = this.evaluateExpression(objectReference + ".getParent().getPositionForView(" + objectReference + ")", evalContext, nodeManager);
        Value resourceNumberIdValue = this.evaluateExpression(objectReference + ".getId()", evalContext, nodeManager);
        int resourceNumberId = resourceNumberIdValue == null ? -1 : Integer.parseInt(this.getStringValue(resourceNumberIdValue));
        Value resourceId = resourceNumberId == -1 ? null : this.evaluateExpression(objectReference + ".getResources().getResourceName(" + resourceNumberId + ")", evalContext, nodeManager);
        Value contentDescription = this.evaluateExpression(objectReference + ".getContentDescription()", evalContext, nodeManager);
        if (childPosition != null || resourceId != null || contentDescription != null || text != null) {
            Value className = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager);
            event.addElementDescriptor(new ElementDescriptor(className == null ? "" : this.getStringValue(className), childPosition == null ? -1 : Integer.parseInt(this.getStringValue(childPosition)), resourceId == null ? "" : this.getStringValue(resourceId), contentDescription == null ? "" : this.getStringValue(contentDescription), text == null ? "" : this.getStringValue(text)));
            return true;
        }
        return false;
    }

    private String getStringValue(@NotNull Value value) {
        if (value instanceof StringReferenceImpl) {
            return ((StringReferenceImpl)value).value();
        }
        return value.toString();
    }

    private Value evaluateExpression(String expression, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        TextWithImports text = TextWithImportsImpl.fromXExpression((XExpression)XExpressionImpl.fromText((String)expression));
        WatchItemDescriptor descriptor = nodeManager.getWatchItemDescriptor(null, text, null);
        descriptor.setContext(evalContext);
        return descriptor.getEvaluateException() != null ? null : descriptor.getValue();
    }

    private abstract class FilteredRequestorAdapter
    implements FilteredRequestor {
        private FilteredRequestorAdapter() {
        }

        public String getSuspendPolicy() {
            return "SuspendAll";
        }

        public boolean isInstanceFiltersEnabled() {
            return false;
        }

        public InstanceFilter[] getInstanceFilters() {
            return new InstanceFilter[0];
        }

        public boolean isCountFilterEnabled() {
            return false;
        }

        public int getCountFilter() {
            return 0;
        }

        public boolean isClassFiltersEnabled() {
            return false;
        }

        public ClassFilter[] getClassFilters() {
            return new ClassFilter[0];
        }

        public ClassFilter[] getClassExclusionFilters() {
            return new ClassFilter[0];
        }
    }
}

