/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.google.common.base.Strings;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;

public class MatcherBuilder {
    private final Project myProject;
    private int matcherCount = 0;
    private final StringBuilder matchers = new StringBuilder();

    public MatcherBuilder(Project project) {
        this.myProject = project;
    }

    public void addMatcher(Kind kind, String matchedString, boolean shouldBox, boolean isAssertionMatcher) {
        if (!Strings.isNullOrEmpty((String)matchedString)) {
            if (kind == Kind.ClassName && !isAssertionMatcher) {
                matchedString = this.getInternalName(matchedString);
            }
            if (this.matcherCount > 0) {
                this.matchers.append(", ");
            }
            if (kind == Kind.ClassName && isAssertionMatcher) {
                this.matchers.append("IsInstanceOf.<View>instanceOf(" + matchedString + ".class)");
            } else {
                this.matchers.append("with").append(kind.name()).append(kind == Kind.ClassName ? "(is(" : "(").append(shouldBox ? StringHelper.boxString(matchedString) : matchedString).append(kind == Kind.ClassName ? "))" : ")");
            }
            ++this.matcherCount;
        }
    }

    private String getInternalName(String className) {
        String intellijInternalName;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
        if (psiClass != null && (intellijInternalName = IntellijLintUtils.getInternalName((PsiClass)psiClass)) != null) {
            return intellijInternalName.replace('/', '.');
        }
        String[] nameFragments = className.split("\\.");
        String resultClassName = "";
        for (int i = 0; i < nameFragments.length - 1; ++i) {
            String fragment = nameFragments[i];
            resultClassName = resultClassName + fragment + (Character.isUpperCase(fragment.charAt(0)) ? "$" : ".");
        }
        resultClassName = resultClassName + nameFragments[nameFragments.length - 1];
        return resultClassName;
    }

    public int getMatcherCount() {
        return this.matcherCount;
    }

    public String getMatchers() {
        return this.matchers.toString();
    }

    public static enum Kind {
        Id,
        Text,
        ContentDescription,
        ClassName;

    }
}

