/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.parser.BindingExpressionBaseVisitor;
import android.databinding.parser.BindingExpressionParser;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.BitShiftExpr;
import android.databinding.tool.expr.CallbackExprModel;
import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.FieldAccessExpr;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.expr.InstanceOfExpr;
import android.databinding.tool.expr.LambdaExpr;
import android.databinding.tool.expr.MathExpr;
import android.databinding.tool.expr.MethodCallExpr;
import android.databinding.tool.expr.MethodReferenceExpr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.SymbolExpr;
import android.databinding.tool.expr.TernaryExpr;
import android.databinding.tool.expr.UnaryExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import com.google.common.base.Objects;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

class ExpressionVisitor
extends BindingExpressionBaseVisitor<Expr> {
    private ExprModel mModel;
    private ParseTreeListener mParseTreeListener;
    private ArrayDeque<ExprModel> mModelStack = new ArrayDeque();
    private BindingTarget mTarget;

    ExpressionVisitor(ExprModel model) {
        this.mModel = model;
    }

    void setParseTreeListener(ParseTreeListener parseTreeListener) {
        this.mParseTreeListener = parseTreeListener;
    }

    public void setBindingTarget(BindingTarget bindingTarget) {
        this.mTarget = bindingTarget;
    }

    private void onEnter(ParserRuleContext context) {
        if (this.mParseTreeListener != null) {
            this.mParseTreeListener.enterEveryRule(context);
        }
    }

    private void onExit(ParserRuleContext context) {
        if (this.mParseTreeListener != null) {
            this.mParseTreeListener.exitEveryRule(context);
        }
    }

    private void pushModel(ExprModel model) {
        Preconditions.checkNotNull((Object)this.mModel, (String)"Cannot put empty model to stack", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)model, (String)"Cannot set null model", (Object[])new Object[0]);
        this.mModelStack.push(this.mModel);
        this.mModel = model;
    }

    private void popModel() {
        Preconditions.checkNotNull((Object)this.mModel, (String)"Cannot have empty mdoel stack", (Object[])new Object[0]);
        Preconditions.check((this.mModelStack.size() > 0 ? 1 : 0) != 0, (String)"Cannot have empty model stack", (Object[])new Object[0]);
        this.mModel = this.mModelStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitRootLambda(BindingExpressionParser.RootLambdaContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            CallbackExprModel callbackModel = new CallbackExprModel(this.mModel);
            ExprModel prev = this.mModel;
            this.pushModel(callbackModel);
            BindingExpressionParser.LambdaExpressionContext lambdaCtx = ctx.lambdaExpression();
            lambdaCtx.args.accept((ParseTreeVisitor)this);
            LambdaExpr lambdaExpr = prev.lambdaExpr((Expr)lambdaCtx.expression().accept((ParseTreeVisitor)this), callbackModel);
            return lambdaExpr;
        }
        finally {
            this.popModel();
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitSingleLambdaParameter(BindingExpressionParser.SingleLambdaParameterContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Preconditions.check((boolean)(this.mModel instanceof CallbackExprModel), (String)"Lambdas can only be used in callbacks.", (Object[])new Object[0]);
            ((CallbackExprModel)this.mModel).callbackArg(ctx.getText());
            Expr expr = null;
            return expr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitLambdaParameterList(BindingExpressionParser.LambdaParameterListContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Preconditions.check((boolean)(this.mModel instanceof CallbackExprModel), (String)"Lambdas can only be used in callbacks.", (Object[])new Object[0]);
            if (ctx.params != null) {
                for (ParseTree item : ctx.params.children) {
                    if (Objects.equal((Object)item.getText(), (Object)",")) continue;
                    ((CallbackExprModel)this.mModel).callbackArg(item.getText());
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitStringLiteral(BindingExpressionParser.StringLiteralContext ctx) {
        try {
            String javaString;
            this.onEnter((ParserRuleContext)ctx);
            if (ctx.SingleQuoteString() != null) {
                String str = ctx.SingleQuoteString().getText();
                String contents = str.substring(1, str.length() - 1);
                contents = contents.replace("\"", "\\\"").replace("\\`", "`");
                javaString = '\"' + contents + '\"';
            } else {
                javaString = ctx.DoubleQuoteString().getText();
            }
            SymbolExpr symbolExpr = this.mModel.symbol(javaString, String.class);
            return symbolExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitRootExpr(BindingExpressionParser.RootExprContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Expr expr = this.mModel.bindingExpr((Expr)ctx.expression().accept((ParseTreeVisitor)this));
            return expr;
        }
        catch (Exception e) {
            System.out.println("Error while parsing! " + ctx.getText());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitGrouping(BindingExpressionParser.GroupingContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Preconditions.check((ctx.children.size() == 3 ? 1 : 0) != 0, (String)"Grouping expression should have 3 children. # of children: %d", (Object[])new Object[]{ctx.children.size()});
            Expr expr = (Expr)((ParseTree)ctx.children.get(1)).accept((ParseTreeVisitor)this);
            return expr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitDotOp(BindingExpressionParser.DotOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
            ModelClass modelClass = analyzer.findClass(ctx.getText(), this.mModel.getImports());
            if (modelClass == null) {
                FieldAccessExpr fieldAccessExpr = this.mModel.field((Expr)ctx.expression().accept((ParseTreeVisitor)this), ctx.Identifier().getSymbol().getText());
                return fieldAccessExpr;
            }
            String name = modelClass.toJavaCode();
            StaticIdentifierExpr expr = this.mModel.staticIdentifier(name);
            expr.setUserDefinedType(name);
            StaticIdentifierExpr staticIdentifierExpr = expr;
            return staticIdentifierExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitFunctionRef(BindingExpressionParser.FunctionRefContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            MethodReferenceExpr methodReferenceExpr = this.mModel.methodReference((Expr)ctx.expression().accept((ParseTreeVisitor)this), ctx.Identifier().getSymbol().getText());
            return methodReferenceExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitQuestionQuestionOp(BindingExpressionParser.QuestionQuestionOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Expr left = (Expr)ctx.left.accept((ParseTreeVisitor)this);
            TernaryExpr ternaryExpr = this.mModel.ternary(this.mModel.comparison("==", left, this.mModel.symbol("null", Object.class)), (Expr)ctx.right.accept((ParseTreeVisitor)this), left);
            return ternaryExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitTerminal(TerminalNode node) {
        try {
            Class<Object> classType;
            this.onEnter((ParserRuleContext)node.getParent());
            int type = node.getSymbol().getType();
            switch (type) {
                case 47: {
                    classType = Integer.TYPE;
                    break;
                }
                case 48: {
                    classType = Float.TYPE;
                    break;
                }
                case 49: {
                    classType = Boolean.TYPE;
                    break;
                }
                case 50: {
                    classType = Character.TYPE;
                    break;
                }
                case 51: 
                case 52: {
                    classType = String.class;
                    break;
                }
                case 53: {
                    classType = Object.class;
                    break;
                }
                case 46: {
                    classType = Void.TYPE;
                    break;
                }
                default: {
                    throw new RuntimeException("cannot create expression from terminal node " + node.toString());
                }
            }
            SymbolExpr symbolExpr = this.mModel.symbol(node.getText(), classType);
            return symbolExpr;
        }
        finally {
            this.onExit((ParserRuleContext)node.getParent());
        }
    }

    public Expr visitComparisonOp(BindingExpressionParser.ComparisonOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            ComparisonExpr comparisonExpr = this.mModel.comparison(ctx.op.getText(), (Expr)ctx.left.accept((ParseTreeVisitor)this), (Expr)ctx.right.accept((ParseTreeVisitor)this));
            return comparisonExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitIdentifier(BindingExpressionParser.IdentifierContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            IdentifierExpr identifierExpr = this.mModel.identifier(ctx.getText());
            return identifierExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitTernaryOp(BindingExpressionParser.TernaryOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            TernaryExpr ternaryExpr = this.mModel.ternary((Expr)ctx.left.accept((ParseTreeVisitor)this), (Expr)ctx.iftrue.accept((ParseTreeVisitor)this), (Expr)ctx.iffalse.accept((ParseTreeVisitor)this));
            return ternaryExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitMethodInvocation(BindingExpressionParser.MethodInvocationContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            ArrayList<Expr> args = new ArrayList<Expr>();
            if (ctx.args != null) {
                for (ParseTree item : ctx.args.children) {
                    if (Objects.equal((Object)item.getText(), (Object)",")) continue;
                    args.add((Expr)item.accept((ParseTreeVisitor)this));
                }
            }
            MethodCallExpr methodCallExpr = this.mModel.methodCall((Expr)ctx.target.accept((ParseTreeVisitor)this), ctx.Identifier().getText(), args);
            return methodCallExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitMathOp(BindingExpressionParser.MathOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            MathExpr mathExpr = this.mModel.math((Expr)ctx.left.accept((ParseTreeVisitor)this), ctx.op.getText(), (Expr)ctx.right.accept((ParseTreeVisitor)this));
            return mathExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitAndOrOp(BindingExpressionParser.AndOrOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            TernaryExpr ternaryExpr = this.mModel.logical((Expr)ctx.left.accept((ParseTreeVisitor)this), ctx.op.getText(), (Expr)ctx.right.accept((ParseTreeVisitor)this));
            return ternaryExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitBinaryOp(BindingExpressionParser.BinaryOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            MathExpr mathExpr = this.mModel.math((Expr)ctx.left.accept((ParseTreeVisitor)this), ctx.op.getText(), (Expr)ctx.right.accept((ParseTreeVisitor)this));
            return mathExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitBitShiftOp(BindingExpressionParser.BitShiftOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            BitShiftExpr bitShiftExpr = this.mModel.bitshift((Expr)ctx.left.accept((ParseTreeVisitor)this), ctx.op.getText(), (Expr)ctx.right.accept((ParseTreeVisitor)this));
            return bitShiftExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitInstanceOfOp(BindingExpressionParser.InstanceOfOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            InstanceOfExpr instanceOfExpr = this.mModel.instanceOfOp((Expr)ctx.expression().accept((ParseTreeVisitor)this), ctx.type().getText());
            return instanceOfExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitUnaryOp(BindingExpressionParser.UnaryOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            UnaryExpr unaryExpr = this.mModel.unary(ctx.op.getText(), (Expr)ctx.expression().accept((ParseTreeVisitor)this));
            return unaryExpr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr visitResources(BindingExpressionParser.ResourcesContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            ArrayList<Expr> args = new ArrayList<Expr>();
            if (ctx.resourceParameters() != null) {
                for (ParseTree item : ctx.resourceParameters().expressionList().children) {
                    if (Objects.equal((Object)item.getText(), (Object)",")) continue;
                    args.add((Expr)item.accept((ParseTreeVisitor)this));
                }
            }
            String resourceReference = ctx.ResourceReference().getText();
            int colonIndex = resourceReference.indexOf(58);
            int slashIndex = resourceReference.indexOf(47);
            String packageName = colonIndex < 0 ? null : resourceReference.substring(1, colonIndex).trim();
            int startIndex = Math.max(1, colonIndex + 1);
            String resourceType = resourceReference.substring(startIndex, slashIndex).trim();
            String resourceName = resourceReference.substring(slashIndex + 1).trim();
            Expr expr = this.mModel.resourceExpr(this.mTarget, packageName, resourceType, resourceName, args);
            return expr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitBracketOp(BindingExpressionParser.BracketOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Expr expr = this.mModel.bracketExpr((Expr)this.visit((ParseTree)ctx.expression(0)), (Expr)this.visit((ParseTree)ctx.expression(1)));
            return expr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }

    public Expr visitCastOp(BindingExpressionParser.CastOpContext ctx) {
        try {
            this.onEnter((ParserRuleContext)ctx);
            Expr expr = this.mModel.castExpr(ctx.type().getText(), (Expr)this.visit((ParseTree)ctx.expression()));
            return expr;
        }
        finally {
            this.onExit((ParserRuleContext)ctx);
        }
    }
}

