/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.soap.JiraSoapTask;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraLegacyApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraLegacyApi.class);
    @NonNls
    private static final String RSS_SEARCH_PATH = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml";
    public static final String RSS_ISSUE_PATH = "/si/jira.issueviews:issue-xml/";

    public JiraLegacyApi(@NotNull JiraRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    public List<Task> findTasks(@NotNull String query, int max) throws Exception {
        GetMethod method = new GetMethod(this.myRepository.getUrl() + RSS_SEARCH_PATH);
        method.setQueryString(new NameValuePair[]{new NameValuePair("tempMax", String.valueOf(max)), new NameValuePair("assignee", TaskUtil.encodeUrl((String)this.myRepository.getUsername())), new NameValuePair("reset", "true"), new NameValuePair("sorter/field", "updated"), new NameValuePair("sorter/order", "DESC"), new NameValuePair("pager/start", "0")});
        return this.processRSS(method);
    }

    private List<Task> processRSS(@NotNull GetMethod method) throws Exception {
        int code = this.myRepository.getHttpClient().executeMethod((HttpMethod)method);
        if (code != 200) {
            throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{code, method.getStatusText()}));
        }
        Element root = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getRootElement();
        Element channel = root.getChild("channel");
        if (channel != null) {
            List children = channel.getChildren("item");
            LOG.debug("Total issues in JIRA RSS feed: " + children.size());
            return ContainerUtil.map((Collection)children, (Function)new Function<Element, Task>(){

                public Task fun(Element element) {
                    return new JiraSoapTask(element, (TaskRepository)JiraLegacyApi.this.myRepository);
                }
            });
        }
        LOG.warn("JIRA channel not found");
        return ContainerUtil.emptyList();
    }

    @Override
    @Nullable
    public Task findTask(@NotNull String key) throws Exception {
        try {
            List<Task> tasks = this.processRSS(new GetMethod(this.myRepository.getUrl() + RSS_ISSUE_PATH + key + '/' + key + ".xml"));
            return tasks.isEmpty() ? null : tasks.get(0);
        }
        catch (Exception e) {
            LOG.warn("Cannot get issue " + key + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    public final JiraRemoteApi.ApiType getType() {
        return JiraRemoteApi.ApiType.LEGACY;
    }

    @Override
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        return Collections.emptySet();
    }

    @Override
    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        throw new Exception(TaskBundle.message((String)"jira.failure.no.state.update", (Object[])new Object[0]));
    }

    @Override
    public void updateTimeSpend(@NotNull LocalTask task, @NotNull String timeSpent, String comment) throws Exception {
        throw new Exception(TaskBundle.message((String)"jira.failure.no.time.spent", (Object[])new Object[0]));
    }
}

