/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedString findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        Object object;
        ClassKey classKey = new ClassKey(clazz);
        Object object2 = this;
        synchronized (object2) {
            if (this._rootNames == null) {
                this._rootNames = new LRUMap(20, 200);
            } else {
                object = (SerializedString)this._rootNames.get(classKey);
                if (object != null) {
                    return object;
                }
            }
        }
        object2 = mapperConfig.introspectClassAnnotations(clazz);
        object = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = ((BeanDescription)object2).getClassInfo();
        PropertyName propertyName = ((AnnotationIntrospector)object).findRootName(annotatedClass);
        String string = propertyName == null || !propertyName.hasSimpleName() ? clazz.getSimpleName() : propertyName.getSimpleName();
        SerializedString serializedString = new SerializedString(string);
        RootNameLookup rootNameLookup = this;
        synchronized (rootNameLookup) {
            this._rootNames.put(classKey, serializedString);
        }
        return serializedString;
    }
}

