/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

class ParentTreeNode
extends UpdaterTreeNode {
    private final AndroidVersion myVersion;
    private final String myTitle;
    private PackageNodeModel.SelectedState myInitialState;

    public ParentTreeNode(AndroidVersion version) {
        this.myVersion = version;
        this.myTitle = null;
    }

    public ParentTreeNode(String title) {
        this.myTitle = title;
        this.myVersion = null;
    }

    @Override
    public PackageNodeModel.SelectedState getInitialState() {
        if (this.myInitialState == null) {
            boolean hasInstalled = false;
            boolean hasNotInstalled = false;
            Enumeration<TreeNode> children = this.children();
            while (children.hasMoreElements()) {
                UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
                if (child.getInitialState() == PackageNodeModel.SelectedState.MIXED) {
                    return PackageNodeModel.SelectedState.MIXED;
                }
                if (child.getInitialState() == PackageNodeModel.SelectedState.INSTALLED) {
                    hasInstalled = true;
                    continue;
                }
                hasNotInstalled = true;
            }
            this.myInitialState = hasInstalled ? (hasNotInstalled ? PackageNodeModel.SelectedState.MIXED : PackageNodeModel.SelectedState.INSTALLED) : PackageNodeModel.SelectedState.NOT_INSTALLED;
        }
        return this.myInitialState;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    public PackageNodeModel.SelectedState getCurrentState() {
        boolean foundInstalled = false;
        boolean foundNotInstalled = false;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            if (child.getCurrentState() != PackageNodeModel.SelectedState.INSTALLED) {
                foundNotInstalled = true;
            }
            if (child.getCurrentState() == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            foundInstalled = true;
        }
        if (foundInstalled && foundNotInstalled) {
            return PackageNodeModel.SelectedState.MIXED;
        }
        if (foundInstalled) {
            return PackageNodeModel.SelectedState.INSTALLED;
        }
        return PackageNodeModel.SelectedState.NOT_INSTALLED;
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof ParentTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((ParentTreeNode)o).myVersion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParentTreeNode)) {
            return false;
        }
        if (this.myVersion != null) {
            return this.myVersion.equals((Object)((ParentTreeNode)obj).myVersion);
        }
        return this.getStatusString().equals(((ParentTreeNode)obj).getStatusString());
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String title = this.myTitle;
        if (title == null) {
            title = SummaryTreeNode.getDescription(this.myVersion);
        }
        renderer.getTextRenderer().append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            child.setState(state == PackageNodeModel.SelectedState.MIXED ? child.getInitialState() : state);
        }
    }
}

