/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import org.jetbrains.annotations.NotNull;

class PackageNodeModel {
    private final UpdatablePackage myPkg;
    private SelectedState myState;
    private final String myTitle;

    public PackageNodeModel(@NotNull UpdatablePackage pkg) {
        String shortRevision;
        RepoPackage representative = pkg.getRepresentative();
        String name = representative.getDisplayName();
        String suffix = representative.getPath().substring(representative.getPath().lastIndexOf(59) + 1);
        try {
            shortRevision = Revision.parseRevision((String)suffix).toShortString();
        }
        catch (NumberFormatException ignore) {
            shortRevision = null;
        }
        if (representative.getDisplayName().endsWith(suffix) || shortRevision != null && representative.getDisplayName().endsWith(shortRevision)) {
            name = suffix;
        }
        this.myPkg = pkg;
        if (pkg.getRepresentative().obsolete()) {
            name = name + " (Obsolete)";
        }
        this.myTitle = name;
    }

    @NotNull
    public UpdatablePackage getPkg() {
        return this.myPkg;
    }

    public SelectedState getState() {
        return this.myState;
    }

    public void setState(@NotNull SelectedState state) {
        this.myState = state;
    }

    public String getTitle() {
        return this.myTitle;
    }

    static enum SelectedState {
        NOT_INSTALLED,
        MIXED,
        INSTALLED;

    }
}

