/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DownloadStatusColumnInfo
extends ColumnInfo<UpdaterTreeNode, Icon> {
    DownloadStatusColumnInfo() {
        super(" ");
    }

    public int getWidth(JTable table) {
        return JBUI.scale((int)30);
    }

    @Nullable
    public TableCellRenderer getRenderer(UpdaterTreeNode node) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public void setText(String text) {
            }
        };
        IconInfo info = this.getIconInfo(node);
        renderer.setIcon(info.getIcon());
        renderer.getAccessibleContext().setAccessibleName(info.getName());
        return renderer;
    }

    @Nullable
    public Icon valueOf(UpdaterTreeNode node) {
        return this.getIconInfo(node).getIcon();
    }

    @NotNull
    public IconInfo getIconInfo(UpdaterTreeNode node) {
        if (node == null || !node.isLeaf()) {
            return IconInfo.Empty;
        }
        if (node.getCurrentState() != node.getInitialState()) {
            if (node.getCurrentState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                return new IconInfo(AllIcons.Actions.Delete, "Action: delete local files");
            }
            if (node.getCurrentState() == PackageNodeModel.SelectedState.INSTALLED) {
                return new IconInfo(AllIcons.Actions.Download, "Action: download files locally");
            }
            assert (false) : "Invalid state selected: " + (Object)((Object)node.getCurrentState());
        }
        return IconInfo.Empty;
    }

    private static class IconInfo {
        private final Icon myIcon;
        private final String myName;
        public static IconInfo Empty = new IconInfo(null, "Action: no change");

        public IconInfo(Icon icon, String name) {
            this.myIcon = icon;
            this.myName = name;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public String getName() {
            return this.myName;
        }
    }
}

