/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.DebugConfigurationAction;
import com.google.gct.testing.ShowScreenshotsAction;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import javax.swing.JComponent;

public class GoogleCloudTestRunnerToolbarPanel
extends SMTRunnerToolbarPanel {
    public GoogleCloudTestRunnerToolbarPanel(TestConsoleProperties properties, TestFrameworkRunningModel model, JComponent contentPane) {
        super(properties, model, contentPane);
        int lastComponentIndex = this.getComponentCount() - 1;
        ActionToolbarImpl actionToolbar = (ActionToolbarImpl)this.getComponent(lastComponentIndex);
        DefaultActionGroup cloudActionGroup = new DefaultActionGroup(null, false);
        int separatorCounter = 0;
        boolean cloudActionsAdded = false;
        for (AnAction action : actionToolbar.getActions(true)) {
            cloudActionGroup.add(action);
            if (cloudActionsAdded) continue;
            if (action instanceof Separator) {
                ++separatorCounter;
            }
            if (separatorCounter != 3) continue;
            this.addCloudActions(cloudActionGroup);
            cloudActionsAdded = true;
        }
        this.remove(lastComponentIndex);
        this.add(ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", (ActionGroup)cloudActionGroup, true).getComponent(), "Center");
    }

    private void addCloudActions(DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowScreenshotsAction());
        if (Boolean.getBoolean("enable.google.cloud.debugging")) {
            actionGroup.addAction((AnAction)new DebugConfigurationAction());
        }
        actionGroup.addSeparator();
    }
}

